/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;

public class PathSerializer
extends SimpleTypeSerializer<Path> {
    public PathSerializer() {
        super(DataType.PATH);
    }

    @Override
    protected Path readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        MutablePath path = (MutablePath)MutablePath.make();
        List labels = (List)context.read(buffer);
        List objects = (List)context.read(buffer);
        if (labels.size() != objects.size()) {
            throw new IllegalStateException("Format for Path object requires that the labels and objects fields be of the same length");
        }
        for (int ix = 0; ix < labels.size(); ++ix) {
            path.extend(objects.get(ix), (Set)labels.get(ix));
        }
        return ReferenceFactory.detach((Path)path);
    }

    @Override
    protected void writeValue(Path value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.write(value.labels(), buffer);
        context.write(value.objects(), buffer);
    }
}

