/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.YearMonth;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class YearMonthSerializer
extends SimpleTypeSerializer<YearMonth> {
    public YearMonthSerializer() {
        super(DataType.YEARMONTH);
    }

    @Override
    protected YearMonth readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return YearMonth.of(buffer.readInt(), buffer.readByte());
    }

    @Override
    protected void writeValue(YearMonth value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.getYear()).writeByte(value.getMonthValue());
    }
}

