/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;

public class BulkSetSerializer
extends SimpleTypeSerializer<BulkSet> {
    public BulkSetSerializer() {
        super(DataType.BULKSET);
    }

    @Override
    protected BulkSet readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        BulkSet result = new BulkSet();
        for (int i = 0; i < length; ++i) {
            result.add(context.read(buffer), buffer.readLong());
        }
        return result;
    }

    @Override
    protected void writeValue(BulkSet value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        Map raw = value.asBulk();
        buffer.writeInt(raw.size());
        for (Object key : raw.keySet()) {
            context.write(key, buffer);
            buffer.writeLong(value.get(key));
        }
    }
}

