/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.StepPosition;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TraversalHelper {
    private TraversalHelper() {
    }

    public static boolean isLocalProperties(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (step instanceof RepeatStep) {
                for (Traversal.Admin admin : ((RepeatStep)step).getGlobalChildren()) {
                    if (!TraversalHelper.hasStepOfAssignableClass(VertexStep.class, admin)) continue;
                    return false;
                }
                continue;
            }
            if (step instanceof VertexStep) {
                return false;
            }
            if (step instanceof EdgeVertexStep) {
                return false;
            }
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin admin : ((TraversalParent)((Object)step)).getLocalChildren()) {
                if (TraversalHelper.isLocalProperties(admin)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLocalStarGraph(Traversal.Admin<?, ?> traversal) {
        return 'x' != TraversalHelper.isLocalStarGraph(traversal, 'v');
    }

    private static char isLocalStarGraph(Traversal.Admin<?, ?> traversal, char state) {
        if (state == 'u' && (traversal instanceof ElementValueTraversal || traversal instanceof TokenTraversal && !((TokenTraversal)traversal).getToken().equals(T.id))) {
            return 'x';
        }
        for (Step step : traversal.getSteps()) {
            char s;
            if ((step instanceof PropertiesStep || step instanceof LabelStep || step instanceof PropertyMapStep) && state == 'u') {
                return 'x';
            }
            if (step instanceof VertexStep) {
                if (state == 'u') {
                    return 'x';
                }
                state = (char)(((VertexStep)step).returnsVertex() ? 117 : 101);
                continue;
            }
            if (step instanceof EdgeVertexStep) {
                state = (char)117;
                continue;
            }
            if (step instanceof HasContainerHolder && state == 'u') {
                for (HasContainer hasContainer : ((HasContainerHolder)((Object)step)).getHasContainers()) {
                    if (hasContainer.getKey().equals(T.id.getAccessor())) continue;
                    return 'x';
                }
                continue;
            }
            if (!(step instanceof TraversalParent)) continue;
            char currState = state;
            HashSet<Character> states = new HashSet<Character>();
            for (Traversal.Admin local : ((TraversalParent)((Object)step)).getLocalChildren()) {
                s = TraversalHelper.isLocalStarGraph(local, currState);
                if ('x' == s) {
                    return 'x';
                }
                states.add(Character.valueOf(s));
            }
            if (!(step instanceof ByModulating)) {
                if (states.contains(Character.valueOf('u'))) {
                    state = (char)117;
                } else if (states.contains(Character.valueOf('e'))) {
                    state = (char)101;
                }
            }
            states.clear();
            if (step instanceof SelectStep || step instanceof SelectOneStep) {
                states.add(Character.valueOf('u'));
            }
            for (Traversal.Admin local : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                s = TraversalHelper.isLocalStarGraph(local, currState);
                if ('x' == s) {
                    return 'x';
                }
                states.add(Character.valueOf(s));
            }
            if (states.contains(Character.valueOf('u'))) {
                state = (char)117;
            } else if (states.contains(Character.valueOf('e'))) {
                state = (char)101;
            }
            if (state == currState || !(step instanceof RepeatStep) && !(step instanceof MatchStep)) continue;
            return 'x';
        }
        return state;
    }

    public static <S, E> void insertBeforeStep(Step<S, E> insertStep, Step<E, ?> afterStep, Traversal.Admin<?, ?> traversal) {
        traversal.addStep(TraversalHelper.stepIndex(afterStep, traversal), insertStep);
    }

    public static <S, E> void insertAfterStep(Step<S, E> insertStep, Step<?, S> beforeStep, Traversal.Admin<?, ?> traversal) {
        traversal.addStep(TraversalHelper.stepIndex(beforeStep, traversal) + 1, insertStep);
    }

    public static <S, E> void replaceStep(Step<S, E> removeStep, Step<S, E> insertStep, Traversal.Admin<?, ?> traversal) {
        int i = TraversalHelper.stepIndex(removeStep, traversal);
        traversal.removeStep(i);
        traversal.addStep(i, insertStep);
    }

    public static <S, E> Step<?, E> insertTraversal(Step<?, S> previousStep, Traversal.Admin<S, E> insertTraversal, Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.insertTraversal(TraversalHelper.stepIndex(previousStep, traversal), insertTraversal, traversal);
    }

    public static <S, E> Step<?, E> insertTraversal(int insertIndex, Traversal.Admin<S, E> insertTraversal, Traversal.Admin<?, ?> traversal) {
        if (0 == traversal.getSteps().size()) {
            Step currentStep = EmptyStep.instance();
            for (Step insertStep : insertTraversal.getSteps()) {
                currentStep = insertStep;
                traversal.addStep(insertStep);
            }
            return currentStep;
        }
        Step currentStep = traversal.getSteps().get(insertIndex);
        for (Step insertStep : insertTraversal.getSteps()) {
            TraversalHelper.insertAfterStep(insertStep, currentStep, traversal);
            currentStep = insertStep;
        }
        return currentStep;
    }

    public static <S, E> void removeToTraversal(Step<S, ?> startStep, Step<?, E> endStep, Traversal.Admin<S, E> newTraversal) {
        Traversal.Admin originalTraversal = startStep.getTraversal();
        Step<Object, ?> currentStep = startStep;
        while (currentStep != endStep && !(currentStep instanceof EmptyStep)) {
            Step<?, ?> temp = currentStep.getNextStep();
            originalTraversal.removeStep(currentStep);
            newTraversal.addStep(currentStep);
            currentStep = temp;
        }
    }

    public static <S, E> int stepIndex(Step<S, E> step, Traversal.Admin<?, ?> traversal) {
        int i = 0;
        for (Step s : traversal.getSteps()) {
            if (s.equals(step, true)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <S> List<S> getStepsOfClass(Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Step step : traversal.getSteps()) {
            if (!step.getClass().equals(stepClass)) continue;
            steps.add(step);
        }
        return steps;
    }

    public static <S> List<S> getStepsOfAssignableClass(Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Step step : traversal.getSteps()) {
            if (!stepClass.isAssignableFrom(step.getClass())) continue;
            steps.add(step);
        }
        return steps;
    }

    public static <S> Optional<S> getLastStepOfAssignableClass(Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        List<S> steps = TraversalHelper.getStepsOfAssignableClass(stepClass, traversal);
        return steps.size() == 0 ? Optional.empty() : Optional.of(steps.get(steps.size() - 1));
    }

    public static <S> Optional<S> getFirstStepOfAssignableClass(Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!stepClass.isAssignableFrom(step.getClass())) continue;
            return Optional.of(step);
        }
        return Optional.empty();
    }

    public static <S> List<S> getStepsOfAssignableClassRecursively(Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.getStepsOfAssignableClassRecursively(null, stepClass, traversal);
    }

    public static <S> List<S> getStepsOfAssignableClassRecursively(Scope scope, Class<S> stepClass, Traversal.Admin<?, ?> traversal) {
        ArrayList list = new ArrayList();
        for (Step step : traversal.getSteps()) {
            if (stepClass.isAssignableFrom(step.getClass())) {
                list.add(step);
            }
            if (!(step instanceof TraversalParent)) continue;
            if (null == scope || Scope.local.equals((Object)scope)) {
                for (Traversal.Admin localChild : ((TraversalParent)((Object)step)).getLocalChildren()) {
                    list.addAll(TraversalHelper.getStepsOfAssignableClassRecursively(stepClass, localChild));
                }
            }
            if (null != scope && !Scope.global.equals((Object)scope)) continue;
            for (Traversal.Admin globalChild : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                list.addAll(TraversalHelper.getStepsOfAssignableClassRecursively(stepClass, globalChild));
            }
        }
        return list;
    }

    public static boolean isGlobalChild(Traversal.Admin<?, ?> traversal) {
        while (!(traversal.getParent() instanceof EmptyStep)) {
            if (traversal.getParent().getLocalChildren().contains(traversal)) {
                return false;
            }
            traversal = traversal.getParent().asStep().getTraversal();
        }
        return true;
    }

    public static boolean hasStepOfClass(Class stepClass, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!step.getClass().equals(stepClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStepOfAssignableClass(Class superClass, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!superClass.isAssignableFrom(step.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStepOfAssignableClassRecursively(Class stepClass, Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.hasStepOfAssignableClassRecursively(null, stepClass, traversal);
    }

    public static boolean hasStepOfAssignableClassRecursively(Scope scope, Class stepClass, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (stepClass.isAssignableFrom(step.getClass())) {
                return true;
            }
            if (!(step instanceof TraversalParent)) continue;
            if (null == scope || Scope.local.equals((Object)scope)) {
                for (Traversal.Admin localChild : ((TraversalParent)((Object)step)).getLocalChildren()) {
                    if (!TraversalHelper.hasStepOfAssignableClassRecursively(stepClass, localChild)) continue;
                    return true;
                }
            }
            if (null != scope && !Scope.global.equals((Object)scope)) continue;
            for (Traversal.Admin globalChild : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                if (!TraversalHelper.hasStepOfAssignableClassRecursively(stepClass, globalChild)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasStepOfAssignableClassRecursively(Collection<Class> stepClasses, Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.hasStepOfAssignableClassRecursively(null, stepClasses, traversal);
    }

    public static boolean hasStepOfAssignableClassRecursively(Scope scope, Collection<Class> stepClasses, Traversal.Admin<?, ?> traversal) {
        if (stepClasses.size() == 1) {
            return TraversalHelper.hasStepOfAssignableClassRecursively(stepClasses.iterator().next(), traversal);
        }
        for (Step step : traversal.getSteps()) {
            if (IteratorUtils.anyMatch(stepClasses.iterator(), stepClass -> stepClass.isAssignableFrom(step.getClass()))) {
                return true;
            }
            if (!(step instanceof TraversalParent)) continue;
            if (null == scope || Scope.local.equals((Object)scope)) {
                for (Traversal.Admin localChild : ((TraversalParent)((Object)step)).getLocalChildren()) {
                    if (!TraversalHelper.hasStepOfAssignableClassRecursively(stepClasses, localChild)) continue;
                    return true;
                }
            }
            if (null != scope && !Scope.global.equals((Object)scope)) continue;
            for (Traversal.Admin globalChild : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                if (!TraversalHelper.hasStepOfAssignableClassRecursively(stepClasses, globalChild)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyStepRecursively(Predicate<Step> predicate, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (predicate.test(step)) {
                return true;
            }
            if (!(step instanceof TraversalParent) || !TraversalHelper.anyStepRecursively(predicate, (TraversalParent)((Object)step))) continue;
            return true;
        }
        return false;
    }

    public static boolean anyStepRecursively(Predicate<Step> predicate, TraversalParent step) {
        for (Traversal.Admin localChild : step.getLocalChildren()) {
            if (!TraversalHelper.anyStepRecursively(predicate, localChild)) continue;
            return true;
        }
        for (Traversal.Admin globalChild : step.getGlobalChildren()) {
            if (!TraversalHelper.anyStepRecursively(predicate, globalChild)) continue;
            return true;
        }
        return false;
    }

    public static void applyTraversalRecursively(Consumer<Traversal.Admin<?, ?>> consumer, Traversal.Admin<?, ?> traversal) {
        consumer.accept(traversal);
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin local : ((TraversalParent)((Object)step)).getLocalChildren()) {
                TraversalHelper.applyTraversalRecursively(consumer, local);
            }
            for (Traversal.Admin global : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                TraversalHelper.applyTraversalRecursively(consumer, global);
            }
        }
    }

    public static <S> void addToCollection(Collection<S> collection, S s, long bulk) {
        if (collection instanceof BulkSet) {
            ((BulkSet)collection).add(s, bulk);
        } else if (collection instanceof Set) {
            collection.add(s);
        } else {
            for (long i = 0L; i < bulk; ++i) {
                collection.add(s);
            }
        }
    }

    public static String getShortName(Step step, int maxLength) {
        String name = step.toString();
        if (name.length() > maxLength) {
            return name.substring(0, maxLength - 3) + "...";
        }
        return name;
    }

    public static void reIdSteps(StepPosition stepPosition, Traversal.Admin<?, ?> traversal) {
        stepPosition.x = 0;
        stepPosition.y = -1;
        stepPosition.z = -1;
        stepPosition.parentId = null;
        Traversal.Admin<Object, Object> current = traversal;
        while (!(current instanceof EmptyTraversal)) {
            ++stepPosition.y;
            TraversalParent parent = current.getParent();
            if (null == stepPosition.parentId && !(parent instanceof EmptyStep)) {
                stepPosition.parentId = parent.asStep().getId();
            }
            if (-1 == stepPosition.z) {
                int i;
                int globalChildrenSize = parent.getGlobalChildren().size();
                for (i = 0; i < globalChildrenSize; ++i) {
                    if (parent.getGlobalChildren().get(i) != current) continue;
                    stepPosition.z = i;
                }
                for (i = 0; i < parent.getLocalChildren().size(); ++i) {
                    if (parent.getLocalChildren().get(i) != current) continue;
                    stepPosition.z = i + globalChildrenSize;
                }
            }
            current = parent.asStep().getTraversal();
        }
        if (-1 == stepPosition.z) {
            stepPosition.z = 0;
        }
        if (null == stepPosition.parentId) {
            stepPosition.parentId = "";
        }
        for (Step step : traversal.getSteps()) {
            step.setId(stepPosition.nextXId());
        }
    }

    public static Traversal.Admin<?, ?> getRootTraversal(Traversal.Admin<?, ?> traversal) {
        while (!(traversal.getParent() instanceof EmptyStep)) {
            traversal = traversal.getParent().asStep().getTraversal();
        }
        return traversal;
    }

    public static boolean hasLabels(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            for (String string : step.getLabels()) {
                if (Graph.Hidden.isHidden(string)) continue;
                return true;
            }
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin admin : ((TraversalParent)((Object)step)).getLocalChildren()) {
                if (!TraversalHelper.hasLabels(admin)) continue;
                return true;
            }
            for (Traversal.Admin admin : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                if (!TraversalHelper.hasLabels(admin)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getLabels(Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.getLabels(new HashSet<String>(), traversal);
    }

    private static Set<String> getLabels(Set<String> labels, Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            labels.addAll(step.getLabels());
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin local : ((TraversalParent)((Object)step)).getLocalChildren()) {
                TraversalHelper.getLabels(labels, local);
            }
            for (Traversal.Admin global : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                TraversalHelper.getLabels(labels, global);
            }
        }
        return labels;
    }

    public static Set<Scoping.Variable> getVariableLocations(Traversal.Admin<?, ?> traversal) {
        return TraversalHelper.getVariableLocations(EnumSet.noneOf(Scoping.Variable.class), traversal);
    }

    private static Set<Scoping.Variable> getVariableLocations(Set<Scoping.Variable> variables, Traversal.Admin<?, ?> traversal) {
        if (variables.size() == 2) {
            return variables;
        }
        Step<?, ?> startStep = traversal.getStartStep();
        if (StartStep.isVariableStartStep(startStep)) {
            variables.add(Scoping.Variable.START);
        } else if (startStep instanceof WherePredicateStep) {
            if (((WherePredicateStep)startStep).getStartKey().isPresent()) {
                variables.add(Scoping.Variable.START);
            }
        } else if (startStep instanceof WhereTraversalStep.WhereStartStep) {
            if (!((WhereTraversalStep.WhereStartStep)startStep).getScopeKeys().isEmpty()) {
                variables.add(Scoping.Variable.START);
            }
        } else if (startStep instanceof MatchStep.MatchStartStep) {
            if (((MatchStep.MatchStartStep)startStep).getSelectKey().isPresent()) {
                variables.add(Scoping.Variable.START);
            }
        } else if (startStep instanceof MatchStep) {
            for (Traversal.Admin<Object, Object> admin : ((MatchStep)startStep).getGlobalChildren()) {
                TraversalHelper.getVariableLocations(variables, admin);
            }
        } else if (startStep instanceof ConnectiveStep || startStep instanceof NotStep || startStep instanceof WhereTraversalStep) {
            for (Traversal.Admin<Object, Object> admin : ((TraversalParent)((Object)startStep)).getLocalChildren()) {
                TraversalHelper.getVariableLocations(variables, admin);
            }
        }
        Step<?, ?> endStep = traversal.getEndStep();
        if (endStep instanceof WherePredicateStep) {
            if (((WherePredicateStep)endStep).getStartKey().isPresent()) {
                variables.add(Scoping.Variable.END);
            }
        } else if (endStep instanceof WhereTraversalStep.WhereEndStep) {
            if (!((WhereTraversalStep.WhereEndStep)endStep).getScopeKeys().isEmpty()) {
                variables.add(Scoping.Variable.END);
            }
        } else if (endStep instanceof MatchStep.MatchEndStep) {
            if (((MatchStep.MatchEndStep)endStep).getMatchKey().isPresent()) {
                variables.add(Scoping.Variable.END);
            }
        } else if (!endStep.getLabels().isEmpty()) {
            variables.add(Scoping.Variable.END);
        }
        return variables;
    }

    public static boolean onGraphComputer(Traversal.Admin<?, ?> traversal) {
        while (!(traversal.getParent() instanceof EmptyStep)) {
            if (traversal.getParent() instanceof TraversalVertexProgramStep) {
                return true;
            }
            traversal = traversal.getParent().asStep().getTraversal();
        }
        return false;
    }

    public static void removeAllSteps(Traversal.Admin<?, ?> traversal) {
        int size = traversal.getSteps().size();
        for (int i = 0; i < size; ++i) {
            traversal.removeStep(0);
        }
    }

    public static void copyLabels(Step<?, ?> fromStep, Step<?, ?> toStep, boolean moveLabels) {
        if (!fromStep.getLabels().isEmpty()) {
            for (String label : moveLabels ? new LinkedHashSet<String>(fromStep.getLabels()) : fromStep.getLabels()) {
                toStep.addLabel(label);
                if (!moveLabels) continue;
                fromStep.removeLabel(label);
            }
        }
    }

    public static boolean hasAllStepsOfClass(Traversal.Admin<?, ?> traversal, Class<?> ... classesToCheck) {
        for (Step step : traversal.getSteps()) {
            boolean foundInstance = false;
            for (Class<?> classToCheck : classesToCheck) {
                if (!classToCheck.isInstance(step)) continue;
                foundInstance = true;
                break;
            }
            if (foundInstance) continue;
            return false;
        }
        return true;
    }

    public static boolean hasStepOfClass(Traversal.Admin<?, ?> traversal, Class<?> ... classesToCheck) {
        for (Step step : traversal.getSteps()) {
            for (Class<?> classToCheck : classesToCheck) {
                if (!classToCheck.isInstance(step)) continue;
                return true;
            }
        }
        return false;
    }

    public static void applySingleLevelStrategies(Traversal.Admin<?, ?> parentTraversal, Traversal.Admin<?, ?> childTraversal, Class<? extends TraversalStrategy> stopAfterStrategy) {
        childTraversal.setStrategies(parentTraversal.getStrategies());
        childTraversal.setSideEffects(parentTraversal.getSideEffects());
        parentTraversal.getGraph().ifPresent(childTraversal::setGraph);
        for (TraversalStrategy<?> strategy : parentTraversal.getStrategies().toList()) {
            strategy.apply(childTraversal);
            if (null == stopAfterStrategy || !stopAfterStrategy.isInstance(strategy)) continue;
            break;
        }
    }

    public static <T extends Traversal.Admin<?, ?>> T addHasContainer(T traversal, HasContainer hasContainer) {
        if (traversal.getEndStep() instanceof HasContainerHolder) {
            ((HasContainerHolder)((Object)traversal.getEndStep())).addHasContainer(hasContainer);
            return traversal;
        }
        return (T)traversal.addStep(new HasStep(traversal, hasContainer));
    }
}

