/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.dsl;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.GremlinDsl;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.ProcessorException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

@SupportedAnnotationTypes(value={"org.apache.tinkerpop.gremlin.process.traversal.dsl.GremlinDsl"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GremlinDslProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Filer filer;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(GremlinDsl.class)) {
                this.validateDSL(element);
                Context ctx = new Context((TypeElement)element);
                this.generateTraversalInterface(ctx);
                this.generateDefaultTraversal(ctx);
                this.generateTraversalSource(ctx);
                this.generateAnonymousTraversal(ctx);
            }
        }
        catch (Exception ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        return true;
    }

    private void generateAnonymousTraversal(Context ctx) throws IOException {
        TypeSpec.Builder anonymousClass = TypeSpec.classBuilder((String)"__").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        anonymousClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        anonymousClass.addMethod(MethodSpec.methodBuilder((String)"start").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"A")).addStatement("return new $N<>()", new Object[]{ctx.defaultTraversalClazz}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"A"), TypeVariableName.get((String)"A")})).build());
        for (ExecutableElement templateMethod : this.findMethodsOfElement(ctx.annotatedDslType, null)) {
            String startGeneric;
            Optional<GremlinDsl.AnonymousMethod> methodAnnotation = Optional.ofNullable(templateMethod.getAnnotation(GremlinDsl.AnonymousMethod.class));
            String methodName = templateMethod.getSimpleName().toString();
            TypeName returnType = methodAnnotation.isPresent() && ((GremlinDsl.AnonymousMethod)methodAnnotation.get()).returnTypeParameters().length > 0 ? this.getOverridenReturnTypeDefinition(ctx.traversalClassName, ((GremlinDsl.AnonymousMethod)methodAnnotation.get()).returnTypeParameters()) : this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod);
            MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addExceptions((Iterable)templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
            String string = startGeneric = methodAnnotation.isPresent() && ((GremlinDsl.AnonymousMethod)methodAnnotation.get()).methodTypeParameters().length > 0 ? ((GremlinDsl.AnonymousMethod)methodAnnotation.get()).methodTypeParameters()[0] : "S";
            if (methodAnnotation.isPresent() && ((GremlinDsl.AnonymousMethod)methodAnnotation.get()).methodTypeParameters().length > 0) {
                Stream.of(((GremlinDsl.AnonymousMethod)methodAnnotation.get()).methodTypeParameters()).map(TypeVariableName::get).forEach(arg_0 -> ((MethodSpec.Builder)methodToAdd).addTypeVariable(arg_0));
            } else {
                templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get((TypeParameterElement)tp)));
                List<? extends TypeMirror> returnTypeArguments = this.getTypeArguments(templateMethod);
                returnTypeArguments.stream().filter(rtm -> rtm instanceof TypeVariable).forEach(rtm -> {
                    if (((TypeVariable)rtm).asElement().getSimpleName().contentEquals("S")) {
                        methodToAdd.addTypeVariable(TypeVariableName.get((String)((TypeVariable)rtm).asElement().getSimpleName().toString()));
                    }
                });
            }
            this.addMethodBody(methodToAdd, templateMethod, "return __.<" + startGeneric + ">start().$L(", ")", methodName);
            anonymousClass.addMethod(methodToAdd.build());
        }
        TypeElement anonymousTraversal = this.elementUtils.getTypeElement(__.class.getCanonicalName());
        Predicate<ExecutableElement> ignore = ee -> ee.getSimpleName().contentEquals("start");
        for (ExecutableElement templateMethod : this.findMethodsOfElement(anonymousTraversal, ignore)) {
            String methodName = templateMethod.getSimpleName().toString();
            TypeName returnType = this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod);
            MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addExceptions((Iterable)templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
            templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get((TypeParameterElement)tp)));
            if (methodName.equals("__")) {
                for (VariableElement variableElement : templateMethod.getParameters()) {
                    methodToAdd.addParameter(ParameterSpec.get((VariableElement)variableElement));
                }
                methodToAdd.varargs(true);
                methodToAdd.addStatement("return inject(starts)", new Object[]{methodName});
            } else if (templateMethod.getTypeParameters().isEmpty()) {
                List<? extends TypeMirror> types = this.getTypeArguments(templateMethod);
                this.addMethodBody(methodToAdd, templateMethod, "return __.<$T>start().$L(", ")", types.get(0), methodName);
            } else {
                this.addMethodBody(methodToAdd, templateMethod, "return __.<A>start().$L(", ")", methodName);
            }
            anonymousClass.addMethod(methodToAdd.build());
        }
        JavaFile traversalSourceJavaFile = JavaFile.builder((String)ctx.packageName, (TypeSpec)anonymousClass.build()).build();
        traversalSourceJavaFile.writeTo(this.filer);
    }

    private void generateTraversalSource(Context ctx) throws IOException {
        TypeElement graphTraversalSourceElement = ctx.traversalSourceDslType;
        TypeSpec.Builder traversalSourceClass = TypeSpec.classBuilder((String)ctx.traversalSourceClazz).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(TypeName.get((TypeMirror)graphTraversalSourceElement.asType()));
        traversalSourceClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Graph.class, "graph", new Modifier[0]).addStatement("super($N)", new Object[]{"graph"}).build());
        traversalSourceClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Graph.class, "graph", new Modifier[0]).addParameter(TraversalStrategies.class, "strategies", new Modifier[0]).addStatement("super($N, $N)", new Object[]{"graph", "strategies"}).build());
        Element tinkerPopsGraphTraversalSource = this.findClassAsElement(graphTraversalSourceElement, GraphTraversalSource.class);
        Predicate<ExecutableElement> ignore = e -> e.getReturnType().getKind() != TypeKind.DECLARED || !((DeclaredType)e.getReturnType()).asElement().getSimpleName().contentEquals(GraphTraversalSource.class.getSimpleName());
        for (ExecutableElement elementOfGraphTraversalSource : this.findMethodsOfElement(tinkerPopsGraphTraversalSource, ignore)) {
            traversalSourceClass.addMethod(this.constructMethod(elementOfGraphTraversalSource, ctx.traversalSourceClassName, "", Modifier.PUBLIC));
        }
        if (!graphTraversalSourceElement.getSimpleName().contentEquals(GraphTraversalSource.class.getSimpleName())) {
            for (ExecutableElement templateMethod : this.findMethodsOfElement(graphTraversalSourceElement, null)) {
                MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder((String)templateMethod.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
                methodToAdd.addStatement("$T clone = this.clone()", new Object[]{ctx.traversalSourceClassName});
                this.addMethodBody(methodToAdd, templateMethod, "return new $T (clone, super.$L(", ").asAdmin())", ctx.defaultTraversalClassName, templateMethod.getSimpleName());
                methodToAdd.returns(this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod));
                traversalSourceClass.addMethod(methodToAdd.build());
            }
        }
        if (ctx.generateDefaultMethods) {
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"addV").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.addV)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, (String) null))", new Object[]{ctx.traversalClassName, AddVertexStartStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Vertex.class), ClassName.get(Vertex.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"addV").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "label", new Modifier[0]).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.addV, label)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, label))", new Object[]{ctx.traversalClassName, AddVertexStartStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Vertex.class), ClassName.get(Vertex.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"addV").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Traversal.class, "vertexLabelTraversal", new Modifier[0]).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.addV, vertexLabelTraversal)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, vertexLabelTraversal))", new Object[]{ctx.traversalClassName, AddVertexStartStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Vertex.class), ClassName.get(Vertex.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"addE").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "label", new Modifier[0]).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.addV, label)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, label))", new Object[]{ctx.traversalClassName, AddEdgeStartStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Edge.class), ClassName.get(Edge.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"addE").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Traversal.class, "edgeLabelTraversal", new Modifier[0]).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.addV, edgeLabelTraversal)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, edgeLabelTraversal))", new Object[]{ctx.traversalClassName, AddEdgeStartStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Edge.class), ClassName.get(Edge.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"V").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object[].class, "vertexIds", new Modifier[0]).varargs(true).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.V, vertexIds)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, $T.class, true, vertexIds))", new Object[]{ctx.traversalClassName, GraphStep.class, Vertex.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Vertex.class), ClassName.get(Vertex.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"E").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object[].class, "edgeIds", new Modifier[0]).varargs(true).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.E, edgeIds)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, $T.class, true, edgeIds))", new Object[]{ctx.traversalClassName, GraphStep.class, Edge.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{ClassName.get(Edge.class), ClassName.get(Edge.class)})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"inject").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeVariableName.get((String)"S")), "starts", new Modifier[0]).varargs(true).addTypeVariable(TypeVariableName.get((String)"S")).addStatement("$N clone = this.clone()", new Object[]{ctx.traversalSourceClazz}).addStatement("clone.getBytecode().addStep($T.inject, starts)", new Object[]{GraphTraversal.Symbols.class}).addStatement("$N traversal = new $N(clone)", new Object[]{ctx.defaultTraversalClazz, ctx.defaultTraversalClazz}).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, starts))", new Object[]{ctx.traversalClassName, InjectStep.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"S")})).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder((String)"getAnonymousTraversalClass").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return Optional.of(__.class)", new Object[0]).returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{Class.class})).build());
        }
        JavaFile traversalSourceJavaFile = JavaFile.builder((String)ctx.packageName, (TypeSpec)traversalSourceClass.build()).build();
        traversalSourceJavaFile.writeTo(this.filer);
    }

    private Element findClassAsElement(Element element, Class<?> clazz) {
        if (element.getSimpleName().contentEquals(clazz.getSimpleName())) {
            return element;
        }
        List<? extends TypeMirror> supertypes = this.typeUtils.directSupertypes(element.asType());
        return this.findClassAsElement(this.typeUtils.asElement(supertypes.get(0)), clazz);
    }

    private void generateDefaultTraversal(Context ctx) throws IOException {
        TypeSpec.Builder defaultTraversalClass = TypeSpec.classBuilder((String)ctx.defaultTraversalClazz).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariables(Arrays.asList(TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E"))).superclass(TypeName.get((TypeMirror)this.elementUtils.getTypeElement(DefaultTraversal.class.getCanonicalName()).asType())).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E")}));
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super()", new Object[0]).build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Graph.class, "graph", new Modifier[0]).addStatement("super($N)", new Object[]{"graph"}).build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ctx.traversalSourceClassName, "traversalSource", new Modifier[0]).addStatement("super($N)", new Object[]{"traversalSource"}).build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ctx.traversalSourceClassName, "traversalSource", new Modifier[0]).addParameter((TypeName)ctx.graphTraversalAdminClassName, "traversal", new Modifier[0]).addStatement("super($N, $N.asAdmin())", new Object[]{"traversalSource", "traversal"}).build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder((String)"iterate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return ($T) super.iterate()", new Object[]{ctx.traversalClassName}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E")})).build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder((String)"asAdmin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return ($T) super.asAdmin()", new Object[]{GraphTraversal.Admin.class}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.graphTraversalAdminClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E")})).build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder((String)"clone").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return ($T) super.clone()", new Object[]{ctx.defaultTraversalClassName}).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.defaultTraversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E")})).build());
        JavaFile defaultTraversalJavaFile = JavaFile.builder((String)ctx.packageName, (TypeSpec)defaultTraversalClass.build()).build();
        defaultTraversalJavaFile.writeTo(this.filer);
    }

    private void generateTraversalInterface(Context ctx) throws IOException {
        TypeSpec.Builder traversalInterface = TypeSpec.interfaceBuilder((String)ctx.traversalClazz).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariables(Arrays.asList(TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E"))).addSuperinterface(TypeName.get((TypeMirror)ctx.annotatedDslType.asType()));
        for (ExecutableElement templateMethod : this.findMethodsOfElement(ctx.annotatedDslType, null)) {
            traversalInterface.addMethod(this.constructMethod(templateMethod, ctx.traversalClassName, ctx.dslName, Modifier.PUBLIC, Modifier.DEFAULT));
        }
        TypeElement graphTraversalElement = this.elementUtils.getTypeElement(GraphTraversal.class.getCanonicalName());
        Predicate<ExecutableElement> ignore = e -> e.getSimpleName().contentEquals("asAdmin") || e.getSimpleName().contentEquals("iterate");
        for (ExecutableElement templateMethod : this.findMethodsOfElement(graphTraversalElement, ignore)) {
            traversalInterface.addMethod(this.constructMethod(templateMethod, ctx.traversalClassName, ctx.dslName, Modifier.PUBLIC, Modifier.DEFAULT));
        }
        traversalInterface.addMethod(MethodSpec.methodBuilder((String)"iterate").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(Override.class).addStatement("$T.super.iterate()", new Object[]{ClassName.get((TypeElement)ctx.annotatedDslType)}).addStatement("return this", new Object[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ctx.traversalClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"S"), TypeVariableName.get((String)"E")})).build());
        JavaFile traversalJavaFile = JavaFile.builder((String)ctx.packageName, (TypeSpec)traversalInterface.build()).build();
        traversalJavaFile.writeTo(this.filer);
    }

    private MethodSpec constructMethod(Element element, ClassName returnClazz, String parent, Modifier ... modifiers) {
        ExecutableElement templateMethod = (ExecutableElement)element;
        String methodName = templateMethod.getSimpleName().toString();
        TypeName returnType = this.getReturnTypeDefinition(returnClazz, templateMethod);
        MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder((String)methodName).addModifiers(modifiers).addAnnotation(Override.class).addExceptions((Iterable)templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
        templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get((TypeParameterElement)tp)));
        String parentCall = parent.isEmpty() ? "" : parent + ".";
        String body = "return ($T) " + parentCall + "super.$L(";
        this.addMethodBody(methodToAdd, templateMethod, body, ")", returnClazz, methodName);
        return methodToAdd.build();
    }

    private void addMethodBody(MethodSpec.Builder methodToAdd, ExecutableElement templateMethod, String startBody, String endBody, Object ... statementArgs) {
        List<? extends VariableElement> parameters = templateMethod.getParameters();
        StringBuilder body = new StringBuilder(startBody);
        int numberOfParams = parameters.size();
        for (int ix = 0; ix < numberOfParams; ++ix) {
            VariableElement param = parameters.get(ix);
            methodToAdd.addParameter(ParameterSpec.get((VariableElement)param));
            body.append(param.getSimpleName());
            if (ix >= numberOfParams - 1) continue;
            body.append(",");
        }
        body.append(endBody);
        if (!parameters.isEmpty() && parameters.get(parameters.size() - 1).asType().getKind() == TypeKind.ARRAY) {
            methodToAdd.varargs(true);
        }
        methodToAdd.addStatement(body.toString(), statementArgs);
    }

    private TypeName getOverridenReturnTypeDefinition(ClassName returnClazz, String[] typeValues) {
        return ParameterizedTypeName.get((ClassName)returnClazz, (TypeName[])Stream.of(typeValues).map(tv -> {
            try {
                return ClassName.get(Class.forName(tv));
            }
            catch (ClassNotFoundException cnfe) {
                if (tv.contains("extends")) {
                    String[] sides = tv.toString().split(" extends ");
                    TypeVariableName name = TypeVariableName.get((String)sides[0]);
                    try {
                        name.withBounds(new TypeName[]{ClassName.get(Class.forName(sides[1]))});
                    }
                    catch (Exception ex) {
                        name.withBounds(new TypeName[]{TypeVariableName.get((String)sides[1])});
                    }
                    return name;
                }
                return TypeVariableName.get((String)tv);
            }
        }).collect(Collectors.toList()).toArray(new TypeName[typeValues.length]));
    }

    private TypeName getReturnTypeDefinition(ClassName returnClazz, ExecutableElement templateMethod) {
        List<? extends TypeMirror> returnTypeArguments = this.getTypeArguments(templateMethod);
        return returnTypeArguments.isEmpty() ? returnClazz : ParameterizedTypeName.get((ClassName)returnClazz, (TypeName[])returnTypeArguments.stream().map(TypeName::get).collect(Collectors.toList()).toArray(new TypeName[returnTypeArguments.size()]));
    }

    private void validateDSL(Element dslElement) throws ProcessorException {
        if (dslElement.getKind() != ElementKind.INTERFACE) {
            throw new ProcessorException(dslElement, "Only interfaces can be annotated with @%s", GremlinDsl.class.getSimpleName());
        }
        TypeElement typeElement = (TypeElement)dslElement;
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(dslElement, "The interface %s is not public.", typeElement.getQualifiedName());
        }
    }

    private List<ExecutableElement> findMethodsOfElement(Element element, Predicate<ExecutableElement> ignore) {
        Predicate<ExecutableElement> test = null == ignore ? ee -> false : ignore;
        return element.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).map(ee -> (ExecutableElement)ee).filter(ee -> !test.test((ExecutableElement)ee)).collect(Collectors.toList());
    }

    private List<? extends TypeMirror> getTypeArguments(ExecutableElement templateMethod) {
        DeclaredType returnTypeMirror = (DeclaredType)templateMethod.getReturnType();
        return returnTypeMirror.getTypeArguments();
    }

    private class Context {
        private final TypeElement annotatedDslType;
        private final String packageName;
        private final String dslName;
        private final String traversalClazz;
        private final ClassName traversalClassName;
        private final String traversalSourceClazz;
        private final ClassName traversalSourceClassName;
        private final String defaultTraversalClazz;
        private final ClassName defaultTraversalClassName;
        private final ClassName graphTraversalAdminClassName;
        private final TypeElement traversalSourceDslType;
        private final boolean generateDefaultMethods;

        public Context(TypeElement dslElement) {
            this.annotatedDslType = dslElement;
            GremlinDsl gremlinDslAnnotation = dslElement.getAnnotation(GremlinDsl.class);
            this.generateDefaultMethods = gremlinDslAnnotation.generateDefaultMethods();
            this.traversalSourceDslType = GremlinDslProcessor.this.elementUtils.getTypeElement(gremlinDslAnnotation.traversalSource());
            this.packageName = this.getPackageName(dslElement, gremlinDslAnnotation);
            this.dslName = dslElement.getSimpleName().toString();
            String dslPrefix = this.dslName.substring(0, this.dslName.length() - "TraversalDSL".length());
            this.traversalClazz = dslPrefix + "Traversal";
            this.traversalClassName = ClassName.get((String)this.packageName, (String)this.traversalClazz, (String[])new String[0]);
            this.traversalSourceClazz = dslPrefix + "TraversalSource";
            this.traversalSourceClassName = ClassName.get((String)this.packageName, (String)this.traversalSourceClazz, (String[])new String[0]);
            this.defaultTraversalClazz = "Default" + this.traversalClazz;
            this.defaultTraversalClassName = ClassName.get((String)this.packageName, (String)this.defaultTraversalClazz, (String[])new String[0]);
            this.graphTraversalAdminClassName = ClassName.get(GraphTraversal.Admin.class);
        }

        private String getPackageName(Element dslElement, GremlinDsl gremlinDslAnnotation) {
            return gremlinDslAnnotation.packageName().isEmpty() ? GremlinDslProcessor.this.elementUtils.getPackageOf(dslElement).getQualifiedName().toString() : gremlinDslAnnotation.packageName();
        }
    }
}

