/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;

public interface Traverser<T>
extends Serializable,
Comparable<Traverser<T>>,
Cloneable {
    public T get();

    public <S> S sack();

    public <S> void sack(S var1);

    public Path path();

    default public <A> A path(String stepLabel) {
        return this.path().get(stepLabel);
    }

    default public <A> A path(Pop pop, String stepLabel) {
        return this.path().get(pop, stepLabel);
    }

    public int loops();

    public int loops(String var1);

    public long bulk();

    default public <A> A sideEffects(String sideEffectKey) throws IllegalArgumentException {
        return (A)this.asAdmin().getSideEffects().get(sideEffectKey);
    }

    default public void sideEffects(String sideEffectKey, Object sideEffectValue) throws IllegalArgumentException {
        this.asAdmin().getSideEffects().add(sideEffectKey, sideEffectValue);
    }

    @Override
    default public int compareTo(Traverser<T> other) throws ClassCastException {
        return ((Comparable)this.get()).compareTo(other.get());
    }

    default public Admin<T> asAdmin() {
        return (Admin)this;
    }

    public Traverser<T> clone();

    public static interface Admin<T>
    extends Traverser<T>,
    Attachable<T> {
        public static final String HALT = "halt";

        public void merge(Admin<?> var1);

        public <R> Admin<R> split(R var1, Step<T, R> var2);

        public Admin<T> split();

        public void addLabels(Set<String> var1);

        public void keepLabels(Set<String> var1);

        public void dropLabels(Set<String> var1);

        public void dropPath();

        public void set(T var1);

        public void initialiseLoops(String var1, String var2);

        public void incrLoops();

        public void resetLoops();

        public String getStepId();

        public void setStepId(String var1);

        default public boolean isHalted() {
            return this.getStepId().equals(HALT);
        }

        public void setBulk(long var1);

        public Admin<T> detach();

        @Override
        public T attach(Function<Attachable<T>, T> var1);

        public void setSideEffects(TraversalSideEffects var1);

        public TraversalSideEffects getSideEffects();

        public Set<String> getTags();
    }
}

