/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

class CollectionSerializer
extends SimpleTypeSerializer<Collection> {
    public CollectionSerializer(DataType dataType) {
        super(dataType);
    }

    @Override
    protected Collection readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(context.read(buffer));
        }
        return result;
    }

    @Override
    protected void writeValue(Collection value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.size());
        for (Object item : value) {
            context.write(item, buffer);
        }
    }
}

