/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.javatuples.Pair;

public final class DefaultTraversalMetrics
implements TraversalMetrics,
Serializable {
    private static final String[] HEADERS = new String[]{"Step", "Count", "Traversers", "Time (ms)", "% Dur"};
    private final Map<String, ImmutableMetrics> stepIndexedMetrics = new HashMap<String, ImmutableMetrics>();
    private long totalStepDuration;
    private Map<Integer, ImmutableMetrics> positionIndexedMetrics = new HashMap<Integer, ImmutableMetrics>();
    private volatile boolean finalized = false;

    public DefaultTraversalMetrics() {
    }

    public DefaultTraversalMetrics(long totalStepDurationNs, List<MutableMetrics> orderedMetrics) {
        this.totalStepDuration = totalStepDurationNs;
        int ix = 0;
        for (MutableMetrics metric : orderedMetrics) {
            this.stepIndexedMetrics.put(metric.getId(), metric.getImmutableClone());
            this.positionIndexedMetrics.put(ix++, metric.getImmutableClone());
        }
    }

    @Override
    public long getDuration(TimeUnit unit) {
        return unit.convert(this.totalStepDuration, MutableMetrics.SOURCE_UNIT);
    }

    @Override
    public Metrics getMetrics(int index) {
        return this.positionIndexedMetrics.get(index);
    }

    @Override
    public Metrics getMetrics(String id) {
        return this.stepIndexedMetrics.get(id);
    }

    public Collection<ImmutableMetrics> getMetrics() {
        return this.positionIndexedMetrics.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)).values();
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Traversal Metrics\n").append(String.format("%-50s %21s %11s %15s %8s", HEADERS));
        sb.append("\n=============================================================================================================");
        this.appendMetrics(this.positionIndexedMetrics.values(), sb, 0);
        sb.append(String.format("%n%50s %21s %11s %15.3f %8s", ">TOTAL", "-", "-", (double)this.getDuration(TimeUnit.MICROSECONDS) / 1000.0, "-"));
        return sb.toString();
    }

    public synchronized void setMetrics(Traversal.Admin traversal, boolean onGraphComputer) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.finalized = true;
        this.handleNestedTraversals(traversal, null, onGraphComputer);
        this.addTopLevelMetrics(traversal, onGraphComputer);
    }

    private void addTopLevelMetrics(Traversal.Admin traversal, boolean onGraphComputer) {
        this.totalStepDuration = 0L;
        List<ProfileStep> profileSteps = TraversalHelper.getStepsOfClass(ProfileStep.class, traversal);
        ArrayList<Pair> tempMetrics = new ArrayList<Pair>(profileSteps.size());
        for (int ii = 0; ii < profileSteps.size(); ++ii) {
            ProfileStep step = profileSteps.get(ii);
            MutableMetrics stepMetrics = onGraphComputer ? (MutableMetrics)traversal.getSideEffects().get(step.getId()) : step.getMetrics();
            this.totalStepDuration += stepMetrics.getDuration(MutableMetrics.SOURCE_UNIT);
            tempMetrics.add(Pair.with((Object)ii, (Object)stepMetrics.clone()));
        }
        tempMetrics.forEach(m -> {
            double dur = (double)((MutableMetrics)m.getValue1()).getDuration(TimeUnit.NANOSECONDS) * 100.0 / (double)this.totalStepDuration;
            ((MutableMetrics)m.getValue1()).setAnnotation("percentDur", dur);
        });
        tempMetrics.forEach(p -> {
            this.stepIndexedMetrics.put(((MutableMetrics)p.getValue1()).getId(), ((MutableMetrics)p.getValue1()).getImmutableClone());
            this.positionIndexedMetrics.put((Integer)p.getValue0(), ((MutableMetrics)p.getValue1()).getImmutableClone());
        });
    }

    private void handleNestedTraversals(Traversal.Admin traversal, MutableMetrics parentMetrics, boolean onGraphComputer) {
        long prevDur = 0L;
        for (int i = 0; i < traversal.getSteps().size(); ++i) {
            MutableMetrics metrics;
            Step step = traversal.getSteps().get(i);
            if (!(step instanceof ProfileStep)) continue;
            MutableMetrics mutableMetrics = metrics = onGraphComputer ? (MutableMetrics)traversal.getSideEffects().get(step.getId()) : ((ProfileStep)step).getMetrics();
            if (null == metrics) continue;
            if (!onGraphComputer) {
                long durBeforeAdjustment = metrics.getDuration(TimeUnit.NANOSECONDS);
                metrics.setDuration(metrics.getDuration(TimeUnit.NANOSECONDS) - prevDur, TimeUnit.NANOSECONDS);
                prevDur = durBeforeAdjustment;
            }
            if (parentMetrics != null) {
                parentMetrics.addNested(metrics);
            }
            if (!(step.getPreviousStep() instanceof TraversalParent)) continue;
            for (Traversal.Admin t : ((TraversalParent)((Object)step.getPreviousStep())).getLocalChildren()) {
                this.handleNestedTraversals(t, metrics, onGraphComputer);
            }
            for (Traversal.Admin t : ((TraversalParent)((Object)step.getPreviousStep())).getGlobalChildren()) {
                this.handleNestedTraversals(t, metrics, onGraphComputer);
            }
        }
    }

    private void appendMetrics(Collection<? extends Metrics> metrics, StringBuilder sb, int indent) {
        for (Metrics metrics2 : metrics) {
            Map<String, Object> annotations;
            StringBuilder metricName = new StringBuilder();
            for (int ii = 0; ii < indent; ++ii) {
                metricName.append("  ");
            }
            metricName.append(metrics2.getName());
            StringBuilder rowName = new StringBuilder(StringUtils.abbreviate((String)metricName.toString(), (int)50));
            Long itemCount = metrics2.getCount("elementCount");
            Long traverserCount = metrics2.getCount("traverserCount");
            Double percentDur = (Double)metrics2.getAnnotation("percentDur");
            sb.append(String.format("%n%-50s", rowName.toString()));
            if (itemCount != null) {
                sb.append(String.format(" %21d", itemCount));
            } else {
                sb.append(String.format(" %21s", ""));
            }
            if (traverserCount != null) {
                sb.append(String.format(" %11d", traverserCount));
            } else {
                sb.append(String.format(" %11s", ""));
            }
            sb.append(String.format(" %15.3f", (double)metrics2.getDuration(TimeUnit.MICROSECONDS) / 1000.0));
            if (percentDur != null) {
                sb.append(String.format(" %8.2f", percentDur));
            }
            if (!(annotations = metrics2.getAnnotations()).isEmpty()) {
                annotations.entrySet().stream().filter(kv -> !((String)kv.getKey()).equals("percentDur")).forEach(kv -> {
                    String prefix = "    \\_";
                    String separator = "=";
                    String k = "    \\_" + StringUtils.abbreviate((String)((String)kv.getKey()), (int)30);
                    int valueIndentLen = "=".length() + k.length() + indent;
                    int leftover = 110 - valueIndentLen;
                    String[] splitValues = DefaultTraversalMetrics.splitOnSize(kv.getValue().toString(), leftover);
                    for (int ix = 0; ix < splitValues.length; ++ix) {
                        if (ix == 0) {
                            sb.append(String.format("%n%s", k + "=" + splitValues[ix]));
                            continue;
                        }
                        sb.append(String.format("%n%s", DefaultTraversalMetrics.padLeft(splitValues[ix], valueIndentLen - 1)));
                    }
                });
            }
            this.appendMetrics(metrics2.getNested(), sb, indent + 1);
        }
    }

    private static String[] splitOnSize(String text, int size) {
        String[] ret = new String[(text.length() + size - 1) / size];
        int counter = 0;
        for (int start = 0; start < text.length(); start += size) {
            ret[counter] = text.substring(start, Math.min(text.length(), start + size));
            ++counter;
        }
        return ret;
    }

    private static String padLeft(String text, int amountToPad) {
        StringBuilder newText = new StringBuilder();
        for (int ix = 0; ix < amountToPad; ++ix) {
            newText.append(" ");
        }
        newText.append(text);
        return newText.toString();
    }
}

