/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TraversalSelectStep<S, E>
extends MapStep<S, E>
implements TraversalParent,
PathProcessor,
ByModulating {
    private final Pop pop;
    private Traversal.Admin<S, E> keyTraversal;
    private Traversal.Admin<E, E> selectTraversal = null;
    private Set<String> keepLabels;

    public TraversalSelectStep(Traversal.Admin traversal, Pop pop, Traversal<S, E> keyTraversal) {
        super(traversal);
        this.pop = pop;
        this.keyTraversal = this.integrateChild(keyTraversal.asAdmin());
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object end = null;
        Iterator<E> keyIterator = TraversalUtil.applyAll(traverser, this.keyTraversal);
        if (keyIterator.hasNext()) {
            E key = keyIterator.next();
            Object object = traverser.get();
            if (object instanceof Map && ((Map)object).containsKey(key)) {
                end = ((Map)object).get(key);
            } else if (key instanceof String) {
                String skey = (String)key;
                if (traverser.getSideEffects().exists(skey)) {
                    end = traverser.getSideEffects().get((String)key);
                } else {
                    Path path = traverser.path();
                    if (path.hasLabel(skey)) {
                        end = null == this.pop ? path.get(skey) : path.get(this.pop, skey);
                    }
                }
            }
        }
        return null != end ? (E)TraversalUtil.applyNullable(end, this.selectTraversal) : null;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.pop, this.keyTraversal, this.selectTraversal});
    }

    @Override
    public TraversalSelectStep<S, E> clone() {
        TraversalSelectStep clone = (TraversalSelectStep)super.clone();
        clone.keyTraversal = this.keyTraversal.clone();
        if (null != this.selectTraversal) {
            clone.selectTraversal = this.selectTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.selectTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.keyTraversal.hashCode();
        if (null != this.selectTraversal) {
            result ^= this.selectTraversal.hashCode();
        }
        if (null != this.pop) {
            result ^= this.pop.hashCode();
        }
        return result;
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        if (null == this.selectTraversal && null == this.keyTraversal) {
            return Collections.emptyList();
        }
        ArrayList children = new ArrayList();
        if (this.selectTraversal != null) {
            children.add(this.selectTraversal);
        }
        if (this.keyTraversal != null) {
            children.add(this.keyTraversal);
        }
        return children;
    }

    @Override
    public void removeLocalChild(Traversal.Admin<?, ?> traversal) {
        if (this.selectTraversal == traversal) {
            this.selectTraversal = null;
        }
        if (this.keyTraversal == traversal) {
            this.keyTraversal = null;
        }
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.selectTraversal = this.integrateChild(selectTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS, TraverserRequirement.PATH);
    }

    public Pop getPop() {
        return this.pop;
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        Traverser.Admin traverser = super.processNextStart();
        if (!(this.getTraversal().getParent() instanceof MatchStep)) {
            PathProcessor.processTraverserPathLabels(traverser, this.keepLabels);
        }
        return traverser;
    }
}

