/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class IndexStep<S, E>
extends MapStep<S, E>
implements TraversalParent,
Configuring {
    private static final IllegalArgumentException INVALID_CONFIGURATION_EXCEPTION = new IllegalArgumentException("WithOptions.indexer requires a single Integer argument (possible values are: WithOptions.[list|map])");
    private final Parameters parameters = new Parameters();
    private Function<Iterator<?>, Object> indexer;
    private IndexerType indexerType;

    public IndexStep(Traversal.Admin traversal) {
        super(traversal);
        this.configure(WithOptions.indexer, WithOptions.list);
    }

    public Function<Iterator<?>, Object> getIndexer() {
        return this.indexer;
    }

    public IndexerType getIndexerType() {
        return this.indexerType;
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        return (E)this.indexer.apply(IteratorUtils.asIterator(traverser.get()));
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.indexer.hashCode();
    }

    private static List<List<Object>> indexedList(Iterator<?> iterator) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        int i = 0;
        while (iterator.hasNext()) {
            list.add(Arrays.asList(iterator.next(), i++));
        }
        return Collections.unmodifiableList(list);
    }

    private static Map<Integer, Object> indexedMap(Iterator<?> iterator) {
        LinkedHashMap map = new LinkedHashMap();
        int i = 0;
        while (iterator.hasNext()) {
            map.put(i++, iterator.next());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0].equals(WithOptions.indexer)) {
            if (keyValues.length != 2 || !(keyValues[1] instanceof Integer)) {
                throw INVALID_CONFIGURATION_EXCEPTION;
            }
            int indexer = (Integer)keyValues[1];
            if (indexer == WithOptions.list) {
                this.indexerType = IndexerType.LIST;
                this.indexer = IndexStep::indexedList;
                return;
            } else {
                if (indexer != WithOptions.map) throw INVALID_CONFIGURATION_EXCEPTION;
                this.indexerType = IndexerType.MAP;
                this.indexer = IndexStep::indexedMap;
            }
            return;
        } else {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public static enum IndexerType {
        LIST(WithOptions.list),
        MAP(WithOptions.map);

        private final int type;

        private IndexerType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

