/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.DefaultTraverserGeneratorFactory;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.StepPosition;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public class DefaultTraversal<S, E>
implements Traversal.Admin<S, E> {
    private Traverser.Admin<E> lastTraverser = EmptyTraverser.instance();
    private Step<?, E> finalEndStep = EmptyStep.instance();
    private final StepPosition stepPosition = new StepPosition();
    protected transient Graph graph;
    protected transient TraversalSource g;
    protected List<Step> steps = new ArrayList<Step>();
    protected List<Step> unmodifiableSteps = Collections.unmodifiableList(this.steps);
    protected TraversalParent parent = EmptyStep.instance();
    protected TraversalSideEffects sideEffects = new DefaultTraversalSideEffects();
    protected TraversalStrategies strategies;
    protected transient TraverserGenerator generator;
    protected Set<TraverserRequirement> requirements;
    protected boolean locked = false;
    protected boolean closed = false;
    protected Bytecode bytecode;

    private DefaultTraversal(Graph graph, TraversalStrategies traversalStrategies, Bytecode bytecode) {
        this.graph = graph;
        this.strategies = traversalStrategies;
        this.bytecode = bytecode;
        this.g = null;
    }

    public DefaultTraversal(Graph graph) {
        this(graph, TraversalStrategies.GlobalCache.getStrategies(graph.getClass()), new Bytecode());
    }

    public DefaultTraversal(TraversalSource traversalSource) {
        this(traversalSource.getGraph(), traversalSource.getStrategies(), traversalSource.getBytecode());
        this.g = traversalSource;
    }

    public DefaultTraversal(TraversalSource traversalSource, Traversal.Admin<S, E> traversal) {
        this(traversalSource.getGraph(), traversalSource.getStrategies(), traversal.getBytecode());
        this.g = traversalSource;
        this.steps.addAll(traversal.getSteps());
    }

    public DefaultTraversal() {
        this(EmptyGraph.instance(), TraversalStrategies.GlobalCache.getStrategies(EmptyGraph.class), new Bytecode());
    }

    public DefaultTraversal(Bytecode bytecode) {
        this(EmptyGraph.instance(), TraversalStrategies.GlobalCache.getStrategies(EmptyGraph.class), bytecode);
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    @Override
    public Traversal.Admin<S, E> asAdmin() {
        return this;
    }

    @Override
    public TraverserGenerator getTraverserGenerator() {
        if (null == this.generator) {
            this.generator = this.parent instanceof EmptyStep ? DefaultTraverserGeneratorFactory.instance().getTraverserGenerator(this.getTraverserRequirements()) : TraversalHelper.getRootTraversal(this).getTraverserGenerator();
        }
        return this.generator;
    }

    @Override
    public void applyStrategies() throws IllegalStateException {
        if (this.locked) {
            throw Traversal.Exceptions.traversalIsLocked();
        }
        TraversalHelper.reIdSteps(this.stepPosition, this);
        this.strategies.applyStrategies(this);
        boolean hasGraph = null != this.graph;
        int j = this.steps.size();
        for (int i = 0; i < j; ++i) {
            Step step = this.steps.get(i);
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin globalChild : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                globalChild.setStrategies(this.strategies);
                globalChild.setSideEffects(this.sideEffects);
                if (hasGraph) {
                    globalChild.setGraph(this.graph);
                }
                globalChild.applyStrategies();
            }
            for (Traversal.Admin localChild : ((TraversalParent)((Object)step)).getLocalChildren()) {
                localChild.setStrategies(this.strategies);
                localChild.setSideEffects(this.sideEffects);
                if (hasGraph) {
                    localChild.setGraph(this.graph);
                }
                localChild.applyStrategies();
            }
        }
        this.finalEndStep = this.getEndStep();
        if (this.getParent() instanceof EmptyStep) {
            this.requirements = null;
            this.getTraverserRequirements();
        }
        this.locked = true;
    }

    @Override
    public Set<TraverserRequirement> getTraverserRequirements() {
        if (null == this.requirements) {
            this.requirements = EnumSet.noneOf(TraverserRequirement.class);
            for (Step step : this.getSteps()) {
                this.requirements.addAll(step.getRequirements());
            }
            if (!this.requirements.contains((Object)TraverserRequirement.LABELED_PATH) && TraversalHelper.hasLabels(this)) {
                this.requirements.add(TraverserRequirement.LABELED_PATH);
            }
            if (!this.getSideEffects().keys().isEmpty()) {
                this.requirements.add(TraverserRequirement.SIDE_EFFECTS);
            }
            if (null != this.getSideEffects().getSackInitialValue()) {
                this.requirements.add(TraverserRequirement.SACK);
            }
            if (this.requirements.contains((Object)TraverserRequirement.ONE_BULK)) {
                this.requirements.remove((Object)TraverserRequirement.BULK);
            }
            this.requirements = Collections.unmodifiableSet(this.requirements);
        }
        return this.requirements;
    }

    @Override
    public List<Step> getSteps() {
        return this.unmodifiableSteps;
    }

    @Override
    public Traverser.Admin<E> nextTraverser() {
        try {
            if (!this.locked) {
                this.applyStrategies();
            }
            if (this.lastTraverser.bulk() > 0L) {
                Traverser.Admin<E> temp = this.lastTraverser;
                this.lastTraverser = EmptyTraverser.instance();
                return temp;
            }
            return (Traverser.Admin)this.finalEndStep.next();
        }
        catch (FastNoSuchElementException e) {
            throw this.parent instanceof EmptyStep ? new NoSuchElementException() : e;
        }
    }

    @Override
    public boolean hasNext() {
        boolean more;
        if (this.isClosed()) {
            return false;
        }
        if (!this.locked) {
            this.applyStrategies();
        }
        boolean bl = more = this.lastTraverser.bulk() > 0L || this.finalEndStep.hasNext();
        if (!more) {
            CloseableIterator.closeIterator(this);
        }
        return more;
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw this.parent instanceof EmptyStep ? new NoSuchElementException() : FastNoSuchElementException.instance();
        }
        try {
            if (!this.locked) {
                this.applyStrategies();
            }
            if (this.lastTraverser.bulk() == 0L) {
                this.lastTraverser = (Traverser.Admin)this.finalEndStep.next();
            }
            this.lastTraverser.setBulk(this.lastTraverser.bulk() - 1L);
            return (E)this.lastTraverser.get();
        }
        catch (FastNoSuchElementException e) {
            CloseableIterator.closeIterator(this);
            throw this.parent instanceof EmptyStep ? new NoSuchElementException() : e;
        }
    }

    @Override
    public void reset() {
        this.steps.forEach(Step::reset);
        this.finalEndStep.reset();
        this.lastTraverser = EmptyTraverser.instance();
        this.closed = false;
    }

    @Override
    public void addStart(Traverser.Admin<S> start) {
        if (!this.locked) {
            this.applyStrategies();
        }
        if (!this.steps.isEmpty()) {
            this.steps.get(0).addStart(start);
            this.closed = false;
        }
    }

    @Override
    public void addStarts(Iterator<Traverser.Admin<S>> starts) {
        if (!this.locked) {
            this.applyStrategies();
        }
        if (!this.steps.isEmpty()) {
            this.steps.get(0).addStarts(starts);
            this.closed = false;
        }
    }

    public String toString() {
        return StringFactory.traversalString(this);
    }

    @Override
    public Step<S, ?> getStartStep() {
        return this.steps.isEmpty() ? EmptyStep.instance() : this.steps.get(0);
    }

    @Override
    public Step<?, E> getEndStep() {
        return this.steps.isEmpty() ? EmptyStep.instance() : this.steps.get(this.steps.size() - 1);
    }

    @Override
    public DefaultTraversal<S, E> clone() {
        try {
            DefaultTraversal clone = (DefaultTraversal)super.clone();
            clone.lastTraverser = EmptyTraverser.instance();
            clone.steps = new ArrayList<Step>();
            clone.unmodifiableSteps = Collections.unmodifiableList(clone.steps);
            clone.sideEffects = this.sideEffects.clone();
            clone.strategies = this.strategies;
            clone.bytecode = this.bytecode.clone();
            for (Step step : this.steps) {
                Step clonedStep = step.clone();
                clonedStep.setTraversal(clone);
                EmptyStep previousStep = clone.steps.isEmpty() ? EmptyStep.instance() : clone.steps.get(clone.steps.size() - 1);
                clonedStep.setPreviousStep(previousStep);
                previousStep.setNextStep(clonedStep);
                clone.steps.add(clonedStep);
            }
            clone.finalEndStep = clone.getEndStep();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void notifyClose() {
        this.closed = true;
    }

    @Override
    public void setSideEffects(TraversalSideEffects sideEffects) {
        this.sideEffects = sideEffects;
    }

    @Override
    public TraversalSideEffects getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public void setStrategies(TraversalStrategies strategies) {
        this.strategies = strategies;
    }

    @Override
    public TraversalStrategies getStrategies() {
        return this.strategies;
    }

    @Override
    public <S2, E2> Traversal.Admin<S2, E2> addStep(int index, Step<?, ?> step) throws IllegalStateException {
        if (this.locked) {
            throw Traversal.Exceptions.traversalIsLocked();
        }
        step.setId(this.stepPosition.nextXId());
        this.steps.add(index, step);
        EmptyStep previousStep = this.steps.size() > 0 && index != 0 ? this.steps.get(index - 1) : null;
        EmptyStep nextStep = this.steps.size() > index + 1 ? this.steps.get(index + 1) : null;
        step.setPreviousStep(null != previousStep ? previousStep : EmptyStep.instance());
        step.setNextStep(null != nextStep ? nextStep : EmptyStep.instance());
        if (null != previousStep) {
            previousStep.setNextStep(step);
        }
        if (null != nextStep) {
            nextStep.setPreviousStep(step);
        }
        step.setTraversal(this);
        return this;
    }

    @Override
    public <S2, E2> Traversal.Admin<S2, E2> removeStep(int index) throws IllegalStateException {
        if (this.locked) {
            throw Traversal.Exceptions.traversalIsLocked();
        }
        Step previousStep = this.steps.size() > 0 && index != 0 ? this.steps.get(index - 1) : null;
        Step nextStep = this.steps.size() > index + 1 ? this.steps.get(index + 1) : null;
        this.steps.remove(index);
        if (null != previousStep) {
            previousStep.setNextStep(null == nextStep ? EmptyStep.instance() : nextStep);
        }
        if (null != nextStep) {
            nextStep.setPreviousStep(null == previousStep ? EmptyStep.instance() : previousStep);
        }
        return this;
    }

    @Override
    public void setParent(TraversalParent step) {
        this.parent = step;
    }

    @Override
    public TraversalParent getParent() {
        return this.parent;
    }

    @Override
    public Optional<Graph> getGraph() {
        return Optional.ofNullable(this.graph);
    }

    @Override
    public Optional<TraversalSource> getTraversalSource() {
        return Optional.ofNullable(this.g);
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && this.equals((Traversal.Admin)other);
    }

    public int hashCode() {
        int index = 0;
        int result = this.getClass().hashCode();
        for (Step step : this.asAdmin().getSteps()) {
            result ^= Integer.rotateLeft(step.hashCode(), index++);
        }
        return result;
    }
}

