/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.gremlin.util.iterator.ArrayIterator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class PythonTranslator
implements Translator.ScriptTranslator {
    private static final Set<String> STEP_NAMES = Stream.of(GraphTraversal.class.getMethods()).filter(method -> Traversal.class.isAssignableFrom(method.getReturnType())).map(Method::getName).collect(Collectors.toSet());
    private static final Set<String> NO_STATIC = Stream.of(T.values(), Operator.values()).flatMap(arg -> IteratorUtils.stream(new ArrayIterator<Enum>((T[])arg))).map(arg -> arg.name()).collect(Collectors.toCollection(() -> new HashSet<String>(Collections.singleton("not"))));
    private final String traversalSource;
    private final boolean importStatics;

    PythonTranslator(String traversalSource, boolean importStatics) {
        this.traversalSource = traversalSource;
        this.importStatics = importStatics;
    }

    public static PythonTranslator of(String traversalSource, boolean importStatics) {
        return new PythonTranslator(traversalSource, importStatics);
    }

    public static PythonTranslator of(String traversalSource) {
        return new PythonTranslator(traversalSource, false);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    public String translate(Bytecode bytecode) {
        return this.internalTranslate(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-python";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    private String internalTranslate(String start, Bytecode bytecode) {
        StringBuilder traversalScript = new StringBuilder(start);
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            String methodName = instruction.getOperator();
            Object[] arguments = instruction.getArguments();
            if (0 == arguments.length) {
                traversalScript.append(".").append(this.resolveSymbol(methodName)).append("()");
            } else if (methodName.equals("range") && 2 == arguments.length) {
                if (((Number)arguments[0]).longValue() + 1L == ((Number)arguments[1]).longValue()) {
                    traversalScript.append("[").append(arguments[0]).append("]");
                } else {
                    traversalScript.append("[").append(arguments[0]).append(":").append(arguments[1]).append("]");
                }
            } else if (methodName.equals("limit") && 1 == arguments.length) {
                traversalScript.append("[0:").append(arguments[0]).append("]");
            } else if (methodName.equals("values") && 1 == arguments.length && traversalScript.length() > 3 && !STEP_NAMES.contains(arguments[0].toString())) {
                traversalScript.append(".").append(arguments[0]);
            } else {
                boolean varargsBeware;
                traversalScript.append(".");
                String temp = this.resolveSymbol(methodName) + "(";
                boolean bl = varargsBeware = instruction.getOperator().equals("withStrategies") || instruction.getOperator().equals("withoutStrategies");
                if (varargsBeware) {
                    temp = temp + "[";
                }
                for (Object object : arguments) {
                    temp = temp + this.convertToString(object) + ",";
                }
                temp = temp.substring(0, temp.length() - 1);
                if (varargsBeware) {
                    temp = temp + "]";
                }
                traversalScript.append(temp).append(")");
            }
            if (!this.importStatics || !traversalScript.substring(0, 3).startsWith("__.") || NO_STATIC.stream().filter(name -> traversalScript.substring(3).startsWith(this.resolveSymbol((String)name))).findAny().isPresent()) continue;
            traversalScript.delete(0, 3);
        }
        return traversalScript.toString();
    }

    protected String convertToString(Object object) {
        if (object instanceof Bytecode.Binding) {
            return ((Bytecode.Binding)object).variable();
        }
        if (object instanceof Bytecode) {
            return this.internalTranslate("__", (Bytecode)object);
        }
        if (object instanceof Traversal) {
            return this.convertToString(((Traversal)object).asAdmin().getBytecode());
        }
        if (object instanceof String) {
            return ((String)object).contains("'") || ((String)object).contains(System.lineSeparator()) ? "\"\"\"" + object + "\"\"\"" : "'" + object + "'";
        }
        if (object instanceof Set) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(((Set)object).size());
            for (Object item : (Set)object) {
                set.add(this.convertToString(item));
            }
            return "set(" + ((Object)set).toString() + ")";
        }
        if (object instanceof List) {
            ArrayList<String> list = new ArrayList<String>(((List)object).size());
            for (Object item : (List)object) {
                list.add(this.convertToString(item));
            }
            return ((Object)list).toString();
        }
        if (object instanceof Map) {
            StringBuilder map = new StringBuilder("{");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.append(this.convertToString(entry.getKey())).append(":").append(this.convertToString(entry.getValue())).append(",");
            }
            return map.length() > 1 ? map.substring(0, map.length() - 1) + "}" : map.append("}").toString();
        }
        if (object instanceof Long) {
            return object + "L";
        }
        if (object instanceof TraversalStrategyProxy) {
            return this.resolveTraversalStrategyProxy((TraversalStrategyProxy)object);
        }
        if (object instanceof TraversalStrategy) {
            return this.convertToString(new TraversalStrategyProxy<TraversalStrategy>((TraversalStrategy)object));
        }
        if (object instanceof Boolean) {
            return object.equals(Boolean.TRUE) ? "True" : "False";
        }
        if (object instanceof Class) {
            return ((Class)object).getCanonicalName();
        }
        if (object instanceof VertexProperty.Cardinality) {
            return "Cardinality." + this.resolveSymbol(object.toString());
        }
        if (object instanceof SackFunctions.Barrier) {
            return "Barrier." + this.resolveSymbol(object.toString());
        }
        if (object instanceof TraversalOptionParent.Pick) {
            return "Pick." + this.resolveSymbol(object.toString());
        }
        if (object instanceof Enum) {
            return this.convertStatic(((Enum)object).getDeclaringClass().getSimpleName() + ".") + this.resolveSymbol(object.toString());
        }
        if (object instanceof P) {
            return this.convertPToString((P)object, new StringBuilder()).toString();
        }
        if (object instanceof Element) {
            if (object instanceof Vertex) {
                Vertex vertex = (Vertex)object;
                return "Vertex(" + this.convertToString(vertex.id()) + "," + this.convertToString(vertex.label()) + ")";
            }
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                return "Edge(" + this.convertToString(edge.id()) + "," + this.convertToString(edge.outVertex()) + "," + this.convertToString(edge.label()) + "," + this.convertToString(edge.inVertex()) + ")";
            }
            VertexProperty vertexProperty = (VertexProperty)object;
            return "VertexProperty(" + this.convertToString(vertexProperty.id()) + "," + this.convertToString(vertexProperty.label()) + "," + this.convertToString(vertexProperty.value()) + ")";
        }
        if (object instanceof Lambda) {
            return this.convertLambdaToString((Lambda)object);
        }
        return null == object ? "None" : object.toString();
    }

    private String convertStatic(String name) {
        return this.importStatics ? "" : name;
    }

    private StringBuilder convertPToString(P p, StringBuilder current) {
        if (p instanceof TextP) {
            return this.convertTextPToString((TextP)p, current);
        }
        if (p instanceof ConnectiveP) {
            List list = ((ConnectiveP)p).getPredicates();
            for (int i = 0; i < list.size(); ++i) {
                this.convertPToString(list.get(i), current);
                if (i >= list.size() - 1) continue;
                current.append(p instanceof OrP ? ".or_(" : ".and_(");
            }
            current.append(")");
        } else {
            current.append(this.convertStatic("P.")).append(p.getBiPredicate().toString()).append("(").append(this.convertToString(p.getValue())).append(")");
        }
        return current;
    }

    private StringBuilder convertTextPToString(TextP p, StringBuilder current) {
        current.append(this.convertStatic("TextP.")).append(p.getBiPredicate().toString()).append("(").append(this.convertToString(p.getValue())).append(")");
        return current;
    }

    protected String convertLambdaToString(Lambda lambda) {
        String lambdaString = lambda.getLambdaScript().trim();
        if (lambda.getLambdaLanguage().equalsIgnoreCase("gremlin-python")) {
            return lambdaString.startsWith("lambda") ? lambdaString : "lambda: \"" + lambdaString + "\"";
        }
        return "lambda: \"" + StringEscapeUtils.escapeJava((String)lambdaString) + "\"";
    }

    protected String resolveSymbol(String methodName) {
        return SymbolHelper.toPython(methodName);
    }

    protected String resolveTraversalStrategyProxy(TraversalStrategyProxy proxy) {
        if (proxy.getConfiguration().isEmpty()) {
            return "TraversalStrategy('" + proxy.getStrategyClass().getSimpleName() + "')";
        }
        return "TraversalStrategy('" + proxy.getStrategyClass().getSimpleName() + "'," + this.convertToString(ConfigurationConverter.getMap((Configuration)proxy.getConfiguration())) + ")";
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_PYTHON_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_PYTHON_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toPython(String symbol) {
            return TO_PYTHON_MAP.getOrDefault(symbol, symbol);
        }

        public static String toJava(String symbol) {
            return FROM_PYTHON_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_PYTHON_MAP.put("global", "global_");
            TO_PYTHON_MAP.put("as", "as_");
            TO_PYTHON_MAP.put("in", "in_");
            TO_PYTHON_MAP.put("and", "and_");
            TO_PYTHON_MAP.put("or", "or_");
            TO_PYTHON_MAP.put("is", "is_");
            TO_PYTHON_MAP.put("not", "not_");
            TO_PYTHON_MAP.put("from", "from_");
            TO_PYTHON_MAP.put("list", "list_");
            TO_PYTHON_MAP.put("set", "set_");
            TO_PYTHON_MAP.put("all", "all_");
            TO_PYTHON_MAP.put("with", "with_");
            TO_PYTHON_MAP.forEach((k, v) -> FROM_PYTHON_MAP.put((String)v, (String)k));
        }
    }
}

