/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWarningVerificationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.VerificationStrategy>
implements TraversalStrategy.VerificationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWarningVerificationStrategy.class);
    public static final String THROW_EXCEPTION = "throwException";
    public static final String LOG_WARNING = "logWarning";
    protected final boolean throwException;
    protected final boolean logWarning;

    AbstractWarningVerificationStrategy(Builder builder) {
        this.throwException = builder.throwException;
        this.logWarning = builder.logWarning;
    }

    abstract void verify(Traversal.Admin<?, ?> var1) throws VerificationException;

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        block3: {
            try {
                this.verify(traversal);
            }
            catch (VerificationException ve) {
                if (this.logWarning) {
                    LOGGER.warn(ve.getMessage());
                }
                if (!this.throwException) break block3;
                throw ve;
            }
        }
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>(2);
        m.put(THROW_EXCEPTION, this.throwException);
        m.put(LOG_WARNING, this.logWarning);
        return new MapConfiguration(m);
    }

    public static abstract class Builder<T extends AbstractWarningVerificationStrategy, B extends Builder> {
        protected boolean throwException;
        protected boolean logWarning;

        Builder() {
        }

        public B throwException(boolean throwException) {
            this.throwException = throwException;
            return (B)this;
        }

        public B throwException() {
            return this.throwException(true);
        }

        public B logWarning(boolean logWarning) {
            this.logWarning = logWarning;
            return (B)this;
        }

        public B logWarning() {
            return this.logWarning(true);
        }

        public abstract T create();
    }
}

