/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.util.function.ConstantSupplier;
import org.javatuples.Triplet;

public final class SideEffectStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final List<Triplet<String, Supplier, BinaryOperator>> sideEffects = new ArrayList<Triplet<String, Supplier, BinaryOperator>>();

    private SideEffectStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getParent() instanceof EmptyStep) {
            this.sideEffects.forEach(triplet -> traversal.getSideEffects().register((String)triplet.getValue0(), (Supplier)triplet.getValue1(), (BinaryOperator)triplet.getValue2()));
        }
    }

    public static <A> void addSideEffect(TraversalStrategies traversalStrategies, String key, A value, BinaryOperator<A> reducer) {
        SideEffectStrategy strategy = traversalStrategies.toList().stream().filter(s -> s instanceof SideEffectStrategy).findAny().orElse(null);
        if (null == strategy) {
            strategy = new SideEffectStrategy();
            traversalStrategies.addStrategies(strategy);
        } else {
            SideEffectStrategy cloneStrategy = new SideEffectStrategy();
            cloneStrategy.sideEffects.addAll(strategy.sideEffects);
            strategy = cloneStrategy;
            traversalStrategies.addStrategies(strategy);
        }
        strategy.sideEffects.add((Triplet<String, Supplier, BinaryOperator>)new Triplet((Object)key, null == value ? null : (value instanceof Supplier ? (Supplier<Object>)value : new ConstantSupplier<A>(value)), reducer));
    }

    public boolean contains(String sideEffectKey) {
        return this.sideEffects.stream().anyMatch(triplet -> ((String)triplet.getValue0()).equals(sideEffectKey));
    }

    public Object initialValue(String sideEffectKey) {
        for (Triplet<String, Supplier, BinaryOperator> triplet : this.sideEffects) {
            if (!((String)triplet.getValue0()).equals(sideEffectKey)) continue;
            return ((Supplier)triplet.getValue1()).get();
        }
        return null;
    }
}

