"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils");
var utils_2 = require("../../utils");
var reduceMiddleStepInStepGroup = function (formatSyntaxTree, config) { return function (_a, step) {
    var stepsInStepGroup = _a.stepsInStepGroup, stepGroups = _a.stepGroups;
    var horizontalPosition = config.localIndentation + stepsInStepGroup.map(function (_a) {
        var width = _a.width;
        return width;
    }).reduce(utils_1.sum, 0) + stepsInStepGroup.length;
    return {
        stepsInStepGroup: __spreadArray(__spreadArray([], stepsInStepGroup), [
            formatSyntaxTree(utils_1.pipe(utils_2.withZeroIndentation, utils_2.withDotInfo({ shouldStartWithDot: false, shouldEndWithDot: false }), utils_2.withHorizontalPosition(horizontalPosition))(config))(step),
        ]),
        stepGroups: stepGroups,
    };
}; };
exports.default = reduceMiddleStepInStepGroup;
