/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;

public class TraversalStrategySerializer
extends SimpleTypeSerializer<TraversalStrategy> {
    public TraversalStrategySerializer() {
        super(DataType.TRAVERSALSTRATEGY);
    }

    @Override
    TraversalStrategy readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Class clazz = context.readValue(buffer, Class.class, false);
        Map config = context.readValue(buffer, Map.class, false);
        return new TraversalStrategyProxy(clazz, (Configuration)new MapConfiguration(config));
    }

    @Override
    public ByteBuf writeValue(TraversalStrategy value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.getClass(), allocator, false));
        result.addComponent(true, context.writeValue(TraversalStrategySerializer.translateToBytecode(ConfigurationConverter.getMap((Configuration)value.getConfiguration())), allocator, false));
        return result;
    }

    private static Map<Object, Object> translateToBytecode(Map<Object, Object> conf) {
        LinkedHashMap<Object, Object> newConf = new LinkedHashMap<Object, Object>(conf.size());
        conf.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof Traversal) {
                newConf.put(entry.getKey(), ((Traversal)entry.getValue()).asAdmin().getBytecode());
            } else {
                newConf.put(entry.getKey(), entry.getValue());
            }
        });
        return newConf;
    }
}

