/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;

public class PropertySerializer
extends SimpleTypeSerializer<Property> {
    public PropertySerializer() {
        super(DataType.PROPERTY);
    }

    @Override
    Property readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        ReferenceProperty p = new ReferenceProperty(context.readValue(buffer, String.class, false), context.read(buffer));
        context.read(buffer);
        return p;
    }

    @Override
    public ByteBuf writeValue(Property value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(3);
        result.addComponent(true, context.writeValue(value.key(), allocator, false));
        result.addComponent(true, context.write(value.value(), allocator));
        result.addComponent(true, context.write(null, allocator));
        return result;
    }
}

