/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;

public class PSerializer<T extends P>
extends SimpleTypeSerializer<T> {
    private final Class<T> classOfP;

    public PSerializer(DataType typeOfP, Class<T> classOfP) {
        super(typeOfP);
        this.classOfP = classOfP;
    }

    @Override
    T readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Method m;
        String predicateName = context.readValue(buffer, String.class, false);
        int length = context.readValue(buffer, Integer.class, false);
        Object[] args = new Object[length];
        Class[] argumentClasses = new Class[length];
        boolean collectionType = false;
        for (int i = 0; i < length; ++i) {
            args[i] = context.read(buffer);
            argumentClasses[i] = args[i].getClass();
        }
        switch (predicateName) {
            case "and": {
                return (T)((P)args[0]).and((Predicate)((P)args[1]));
            }
            case "or": {
                return (T)((P)args[0]).or((Predicate)((P)args[1]));
            }
        }
        try {
            m = this.classOfP.getMethod(predicateName, argumentClasses);
        }
        catch (NoSuchMethodException ex0) {
            try {
                m = this.classOfP.getMethod(predicateName, Collection.class);
                collectionType = true;
            }
            catch (NoSuchMethodException ex1) {
                try {
                    m = this.classOfP.getMethod(predicateName, Object.class);
                }
                catch (NoSuchMethodException ex2) {
                    throw new SerializationException("not found");
                }
            }
        }
        try {
            if (Modifier.isStatic(m.getModifiers())) {
                if (collectionType) {
                    return (T)((P)m.invoke(null, Arrays.asList(args)));
                }
                return (T)((P)m.invoke(null, args));
            }
            if (args.length != 2 || !(args[0] instanceof P) || !(args[1] instanceof P)) {
                throw new IllegalStateException(String.format("Could not determine the form of P for %s and %s", predicateName, Arrays.asList(args)));
            }
            P firstP = (P)args[0];
            P secondP = (P)args[1];
            return (T)((P)m.invoke((Object)firstP, secondP));
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf writeValue(T value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        boolean isConnectedP = value instanceof ConnectiveP;
        String predicateName = isConnectedP ? (value instanceof AndP ? "and" : "or") : value.getBiPredicate().toString();
        Object args = isConnectedP ? ((ConnectiveP)value).getPredicates() : value.getValue();
        List<Object> argsAsList = args instanceof Collection ? new ArrayList((Collection)args) : Collections.singletonList(args);
        int length = argsAsList.size();
        CompositeByteBuf result = allocator.compositeBuffer(2 + length);
        result.addComponent(true, context.writeValue(predicateName, allocator, false));
        result.addComponent(true, context.writeValue(length, allocator, false));
        for (Object o : argsAsList) {
            result.addComponent(true, context.write(o, allocator));
        }
        return result;
    }
}

