/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.sql.Timestamp;
import java.util.Date;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class DateSerializer<T extends Date>
extends SimpleTypeSerializer<T> {
    public static final DateSerializer<Date> DateSerializer = new DateSerializer<Date>(DataType.DATE, Date::new);
    public static final DateSerializer<Timestamp> TimestampSerializer = new DateSerializer<Timestamp>(DataType.TIMESTAMP, Timestamp::new);
    private final Function<Long, T> reader;

    private DateSerializer(DataType type, Function<Long, T> reader) {
        super(type);
        this.reader = reader;
    }

    @Override
    T readValue(ByteBuf buffer, GraphBinaryReader context) {
        return (T)((Date)this.reader.apply(buffer.readLong()));
    }

    @Override
    public ByteBuf writeValue(T value, ByteBufAllocator allocator, GraphBinaryWriter context) {
        return allocator.buffer(8).writeLong(((Date)value).getTime());
    }
}

