/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;

public class RequestMessageSerializer {
    public RequestMessage readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        byte version = buffer.readByte();
        assert (version >>> 31 == 1);
        UUID id = context.readValue(buffer, UUID.class, false);
        String op = context.readValue(buffer, String.class, false);
        String processor = context.readValue(buffer, String.class, false);
        RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
        Map args = context.readValue(buffer, Map.class, false);
        args.forEach(builder::addArg);
        return builder.create();
    }

    public ByteBuf writeValue(RequestMessage value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.compositeBuffer(5).addComponents(true, new ByteBuf[]{allocator.buffer(1).writeByte(129), context.writeValue(value.getRequestId(), allocator, false), context.writeValue(value.getOp(), allocator, false), context.writeValue(value.getProcessor(), allocator, false), context.writeValue(value.getArgs(), allocator, false)});
    }
}

