/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.process.remote.traversal;

import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;

import java.util.Set;

/**
 * Generated by the {@link EmbeddedRemoteTraversal} to help simulate a remote traversal side-effects within the same JVM.
 *
 * @author Stephen Mallette (http://stephen.genoprime.com)
 */
public class EmbeddedRemoteTraversalSideEffects extends AbstractRemoteTraversalSideEffects {

    private final TraversalSideEffects sideEffects;

    public EmbeddedRemoteTraversalSideEffects(final TraversalSideEffects sideEffects) {
        this.sideEffects = sideEffects;
    }

    @Override
    public <V> V get(final String key) throws IllegalArgumentException {
        return sideEffects.get(key);
    }

    @Override
    public Set<String> keys() {
        return sideEffects.keys();
    }
}
