/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class Parameters
implements Cloneable,
Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map<Object, List<Object>> parameters = new HashMap<Object, List<Object>>();
    private Set<String> referencedLabels = new HashSet<String>();
    private List<Traversal.Admin<?, ?>> traversals = new ArrayList();

    public boolean contains(Object key) {
        return this.parameters.containsKey(key);
    }

    public void rename(Object oldKey, Object newKey) {
        this.parameters.put(newKey, this.parameters.remove(oldKey));
    }

    public <S, E> List<E> get(Traverser.Admin<S> traverser, Object key, Supplier<E> defaultValue) {
        List<Object> values = this.parameters.get(key);
        if (null == values) {
            return Collections.singletonList(defaultValue.get());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            result.add(value instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)value) : value);
        }
        return result;
    }

    public <E> List<E> get(Object key, Supplier<E> defaultValue) {
        List<Object> list = this.parameters.get(key);
        return null == list ? Collections.singletonList(defaultValue.get()) : list;
    }

    public Object remove(Object key) {
        List<Object> o = this.parameters.remove(key);
        if (IteratorUtils.anyMatch(o.iterator(), p -> p instanceof Traversal.Admin)) {
            this.traversals.clear();
            this.traversals = new ArrayList();
            for (List<Object> list : this.parameters.values()) {
                for (Object object : list) {
                    if (!(object instanceof Traversal.Admin)) continue;
                    Traversal.Admin t = (Traversal.Admin)object;
                    this.addTraversal(t);
                }
            }
        }
        return o;
    }

    public <S> Object[] getKeyValues(Traverser.Admin<S> traverser, Object ... exceptKeys) {
        if (this.parameters.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (Map.Entry<Object, List<Object>> entry : this.parameters.entrySet()) {
            if (ArrayUtils.contains((Object[])exceptKeys, (Object)entry.getKey())) continue;
            for (Object value : entry.getValue()) {
                keyValues.add(entry.getKey() instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)entry.getKey()) : entry.getKey());
                keyValues.add(value instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)value) : value);
            }
        }
        return keyValues.toArray(new Object[keyValues.size()]);
    }

    public Map<Object, List<Object>> getRaw(Object ... exceptKeys) {
        if (this.parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Object> exceptions = Arrays.asList(exceptKeys);
        HashMap<Object, List<Object>> raw = new HashMap<Object, List<Object>>();
        for (Map.Entry<Object, List<Object>> entry : this.parameters.entrySet()) {
            if (exceptions.contains(entry.getKey())) continue;
            raw.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(raw);
    }

    public void set(TraversalParent parent, Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        for (int ix = 0; ix < keyValues.length; ix += 2) {
            if (!(keyValues[ix] instanceof String || keyValues[ix] instanceof T || keyValues[ix] instanceof Traversal)) {
                throw new IllegalArgumentException("The provided key/value array must have a String, T, or Traversal on even array indices");
            }
            if (keyValues[ix + 1] == null) continue;
            for (int iy = 0; iy < 2; ++iy) {
                if (!(keyValues[ix + iy] instanceof Traversal.Admin)) continue;
                Traversal.Admin t = (Traversal.Admin)keyValues[ix + iy];
                this.addTraversal(t);
                if (parent == null) continue;
                parent.integrateChild(t);
            }
            List<Object> values = this.parameters.get(keyValues[ix]);
            if (null == values) {
                values = new ArrayList<Object>();
                values.add(keyValues[ix + 1]);
                this.parameters.put(keyValues[ix], values);
                continue;
            }
            values.add(keyValues[ix + 1]);
        }
    }

    public <S, E> List<Traversal.Admin<S, E>> getTraversals() {
        return this.traversals;
    }

    public Set<String> getReferencedLabels() {
        return this.referencedLabels;
    }

    public Parameters clone() {
        try {
            Parameters clone = (Parameters)super.clone();
            clone.parameters = new HashMap<Object, List<Object>>();
            clone.traversals = new ArrayList();
            for (Map.Entry<Object, List<Object>> entry : this.parameters.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object value : entry.getValue()) {
                    if (value instanceof Traversal.Admin) {
                        Traversal.Admin traversalClone = ((Traversal.Admin)value).clone();
                        clone.traversals.add(traversalClone);
                        values.add(traversalClone);
                        continue;
                    }
                    values.add(value);
                }
                if (entry.getKey() instanceof Traversal.Admin) {
                    Traversal.Admin traversalClone = ((Traversal.Admin)entry.getKey()).clone();
                    clone.traversals.add(traversalClone);
                    clone.parameters.put(traversalClone, values);
                    continue;
                }
                clone.parameters.put(entry.getKey(), values);
            }
            clone.referencedLabels = new HashSet<String>(this.referencedLabels);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        int result = 1;
        for (Map.Entry<Object, List<Object>> entry : this.parameters.entrySet()) {
            result ^= entry.getKey().hashCode();
            for (Object value : entry.getValue()) {
                result ^= Integer.rotateLeft(value.hashCode(), entry.getKey().hashCode());
            }
        }
        return result;
    }

    public String toString() {
        return this.parameters.toString();
    }

    private void addTraversal(Traversal.Admin t) {
        this.traversals.add(t);
        for (Step ss : t.getSteps()) {
            if (!(ss instanceof Scoping)) continue;
            for (String label : ((Scoping)((Object)ss)).getScopeKeys()) {
                this.referencedLabels.add(label);
            }
        }
    }
}

