/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EdgeLabelVerificationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.VerificationStrategy>
implements TraversalStrategy.VerificationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeLabelVerificationStrategy.class);
    private static final String THROW_EXCEPTION = "throwException";
    private static final String LOG_WARNING = "logWarning";
    private final boolean throwException;
    private final boolean logWarning;

    private EdgeLabelVerificationStrategy(boolean throwException, boolean logWarning) {
        this.throwException = throwException;
        this.logWarning = logWarning;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof VertexStep) || ((VertexStep)step).getEdgeLabels().length != 0) continue;
            String msg = String.format("The provided traversal contains a vertex step without any specified edge label: %s\nAlways specify edge labels which restrict traversal paths ensuring optimal performance.", step);
            if (this.logWarning) {
                LOGGER.warn(msg);
            }
            if (!this.throwException) continue;
            throw new VerificationException(msg, traversal);
        }
    }

    public static EdgeLabelVerificationStrategy create(Configuration configuration) {
        return new EdgeLabelVerificationStrategy(configuration.getBoolean(THROW_EXCEPTION, false), configuration.getBoolean(LOG_WARNING, false));
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>(2);
        m.put(THROW_EXCEPTION, this.throwException);
        m.put(LOG_WARNING, this.logWarning);
        return new MapConfiguration(m);
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private boolean throwException;
        private boolean logWarning;

        private Builder() {
        }

        public Builder throwException() {
            return this.throwException(true);
        }

        public Builder throwException(boolean throwException) {
            this.throwException = throwException;
            return this;
        }

        public Builder logWarning() {
            return this.logWarning(true);
        }

        public Builder logWarning(boolean logWarning) {
            this.logWarning = logWarning;
            return this;
        }

        public EdgeLabelVerificationStrategy create() {
            return new EdgeLabelVerificationStrategy(this.throwException, this.logWarning);
        }
    }
}

