/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Parameterizing;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public final class PartitionStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private String writePartition;
    private final String partitionKey;
    private final Set<String> readPartitions;
    private final boolean includeMetaProperties;
    public static final String INCLUDE_META_PROPERTIES = "includeMetaProperties";
    public static final String WRITE_PARTITION = "writePartition";
    public static final String PARTITION_KEY = "partitionKey";
    public static final String READ_PARTITIONS = "readPartitions";

    private PartitionStrategy(Builder builder) {
        this.writePartition = builder.writePartition;
        this.partitionKey = builder.partitionKey;
        this.readPartitions = Collections.unmodifiableSet(builder.readPartitions);
        this.includeMetaProperties = builder.includeMetaProperties;
    }

    public String getWritePartition() {
        return this.writePartition;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Set<String> getReadPartitions() {
        return this.readPartitions;
    }

    public boolean isIncludeMetaProperties() {
        return this.includeMetaProperties;
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        Graph graph = traversal.getGraph().orElseThrow(() -> new IllegalStateException("PartitionStrategy does not work with anonymous Traversals"));
        Graph.Features.VertexFeatures vertexFeatures = graph.features().vertex();
        boolean supportsMetaProperties = vertexFeatures.supportsMetaProperties();
        if (this.includeMetaProperties && !supportsMetaProperties) {
            throw new IllegalStateException("PartitionStrategy is configured to include meta-properties but the Graph does not support them");
        }
        ArrayList<AbstractStep> stepsToInsertHasAfter = new ArrayList<AbstractStep>();
        stepsToInsertHasAfter.addAll(TraversalHelper.getStepsOfAssignableClass(GraphStep.class, traversal));
        stepsToInsertHasAfter.addAll(TraversalHelper.getStepsOfAssignableClass(VertexStep.class, traversal));
        stepsToInsertHasAfter.addAll(TraversalHelper.getStepsOfAssignableClass(EdgeOtherVertexStep.class, traversal));
        stepsToInsertHasAfter.addAll(TraversalHelper.getStepsOfAssignableClass(EdgeVertexStep.class, traversal));
        stepsToInsertHasAfter.forEach(step -> TraversalHelper.insertAfterStep(new HasStep(traversal, new HasContainer(this.partitionKey, P.within(new ArrayList<String>(this.readPartitions)))), step, traversal));
        if (this.includeMetaProperties) {
            List<PropertiesStep> propertiesSteps = TraversalHelper.getStepsOfAssignableClass(PropertiesStep.class, traversal);
            propertiesSteps.forEach(step -> {
                if (step.getPropertyKeys().length > 0 && ElementHelper.keyExists(this.partitionKey, step.getPropertyKeys())) {
                    throw new IllegalStateException("Cannot explicitly request the partitionKey in the traversal");
                }
                if (step.getReturnType() == PropertyType.PROPERTY) {
                    Step next = step.getNextStep();
                    if (!(next instanceof HasStep) || !((HasStep)next).getHasContainers().get(0).getKey().equals(this.partitionKey)) {
                        GraphTraversal choose = __.choose(__.filter(new TypeChecker(VertexProperty.class)), __.has(this.partitionKey, P.within(new ArrayList<String>(this.readPartitions))), __.__(new Object[0])).filter(new PartitionKeyHider());
                        TraversalHelper.insertTraversal(step, choose.asAdmin(), traversal);
                    }
                } else if (step.getReturnType() == PropertyType.VALUE) {
                    GraphTraversal choose = __.choose(__.filter(new TypeChecker(Vertex.class)), __.properties(step.getPropertyKeys()).has(this.partitionKey, P.within(new ArrayList<String>(this.readPartitions))).filter(new PartitionKeyHider()).value(), __.__(new Object[0]).filter(new PartitionKeyHider()));
                    TraversalHelper.insertTraversal(step, choose.asAdmin(), traversal);
                    traversal.removeStep((Step<?, ?>)step);
                } else {
                    throw new IllegalStateException(String.format("%s is not accounting for a particular %s %s", new Object[]{PartitionStrategy.class.getSimpleName(), PropertyType.class.toString(), step.getReturnType()}));
                }
            });
            List<PropertyMapStep> propertyMapSteps = TraversalHelper.getStepsOfAssignableClass(PropertyMapStep.class, traversal);
            propertyMapSteps.forEach(step -> {
                if (step.getPropertyKeys().length > 0 && ElementHelper.keyExists(this.partitionKey, step.getPropertyKeys())) {
                    throw new IllegalStateException("Cannot explicitly request the partitionKey in the traversal");
                }
                if (step.getReturnType() == PropertyType.PROPERTY) {
                    TraversalHelper.insertAfterStep(new LambdaMapStep<Map<String, List<Property>>, Map<String, List<Property>>>(traversal, new MapPropertiesFilter()), step, traversal);
                } else if (step.getReturnType() == PropertyType.VALUE) {
                    PropertyMapStep propertyMapStep = new PropertyMapStep(traversal, step.isIncludeTokens(), PropertyType.PROPERTY, step.getPropertyKeys());
                    TraversalHelper.replaceStep(step, propertyMapStep, traversal);
                    LambdaMapStep<Map<String, List<Property>>, Map<String, List<Property>>> mapPropertiesFilterStep = new LambdaMapStep<Map<String, List<Property>>, Map<String, List<Property>>>(traversal, new MapPropertiesFilter());
                    TraversalHelper.insertAfterStep(mapPropertiesFilterStep, propertyMapStep, traversal);
                    TraversalHelper.insertAfterStep(new LambdaMapStep<Map<String, List<Property>>, Map<String, List<Property>>>(traversal, new MapPropertiesConverter()), mapPropertiesFilterStep, traversal);
                } else {
                    throw new IllegalStateException(String.format("%s is not accounting for a particular %s %s", new Object[]{PartitionStrategy.class.getSimpleName(), PropertyType.class.toString(), step.getReturnType()}));
                }
            });
        }
        List<Step> stepsToInsertPropertyMutations = traversal.getSteps().stream().filter(step -> step instanceof AddEdgeStep || step instanceof AddVertexStep || step instanceof AddEdgeStartStep || step instanceof AddVertexStartStep || this.includeMetaProperties && step instanceof AddPropertyStep).collect(Collectors.toList());
        stepsToInsertPropertyMutations.forEach(step -> {
            ((Mutating)((Object)step)).addPropertyMutations(this.partitionKey, this.writePartition);
            if (this.includeMetaProperties && (step instanceof AddVertexStartStep || step instanceof AddVertexStep)) {
                Parameters parameters = ((Parameterizing)((Object)step)).getParameters();
                Map<Object, List<Object>> params = parameters.getRaw(new Object[0]);
                params.forEach((k, v) -> {
                    if (k instanceof String) {
                        ArrayList addPropertyStepsToAppend = new ArrayList(v.size());
                        VertexProperty.Cardinality cardinality = vertexFeatures.getCardinality((String)k);
                        v.forEach(o -> {
                            AddPropertyStep addPropertyStep = new AddPropertyStep(traversal, cardinality, k, o);
                            addPropertyStep.addPropertyMutations(this.partitionKey, this.writePartition);
                            addPropertyStepsToAppend.add(addPropertyStep);
                            parameters.remove(k);
                        });
                        Collections.reverse(addPropertyStepsToAppend);
                        addPropertyStepsToAppend.forEach(s -> TraversalHelper.insertAfterStep(s, step, traversal));
                    }
                });
            }
        });
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strategy", PartitionStrategy.class.getCanonicalName());
        map.put(INCLUDE_META_PROPERTIES, this.includeMetaProperties);
        if (null != this.writePartition) {
            map.put(WRITE_PARTITION, this.writePartition);
        }
        if (null != this.readPartitions) {
            map.put(READ_PARTITIONS, this.readPartitions);
        }
        if (null != this.partitionKey) {
            map.put(PARTITION_KEY, this.partitionKey);
        }
        return new MapConfiguration(map);
    }

    public static PartitionStrategy create(Configuration configuration) {
        Builder builder = PartitionStrategy.build();
        if (configuration.containsKey(INCLUDE_META_PROPERTIES)) {
            builder.includeMetaProperties(configuration.getBoolean(INCLUDE_META_PROPERTIES));
        }
        if (configuration.containsKey(WRITE_PARTITION)) {
            builder.writePartition(configuration.getString(WRITE_PARTITION));
        }
        if (configuration.containsKey(PARTITION_KEY)) {
            builder.partitionKey(configuration.getString(PARTITION_KEY));
        }
        if (configuration.containsKey(READ_PARTITIONS)) {
            builder.readPartitions(new ArrayList<String>((Collection)configuration.getProperty(READ_PARTITIONS)));
        }
        return builder.create();
    }

    public static final class Builder {
        private String writePartition;
        private String partitionKey;
        private Set<String> readPartitions = new HashSet<String>();
        private boolean includeMetaProperties = false;

        Builder() {
        }

        public Builder includeMetaProperties(boolean includeMetaProperties) {
            this.includeMetaProperties = includeMetaProperties;
            return this;
        }

        public Builder writePartition(String writePartition) {
            this.writePartition = writePartition;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder readPartitions(List<String> readPartitions) {
            this.readPartitions.addAll(readPartitions);
            return this;
        }

        public Builder readPartitions(String ... readPartitions) {
            return this.readPartitions(Arrays.asList(readPartitions));
        }

        @Deprecated
        public Builder addReadPartition(String readPartition) {
            this.readPartitions.add(readPartition);
            return this;
        }

        public PartitionStrategy create() {
            if (this.partitionKey == null || this.partitionKey.isEmpty()) {
                throw new IllegalStateException("The partitionKey cannot be null or empty");
            }
            return new PartitionStrategy(this);
        }
    }

    public final class MapPropertiesConverter
    implements Function<Traverser<Map<String, List<Property>>>, Map<String, List<Property>>>,
    Serializable {
        @Override
        public Map<String, List<Property>> apply(Traverser<Map<String, List<Property>>> mapTraverser) {
            Map<String, List<Property>> values = mapTraverser.get();
            HashMap<String, List<Property>> converted = new HashMap<String, List<Property>>();
            values.entrySet().forEach(p -> {
                List l = ((List)p.getValue()).stream().map(property -> property.value()).collect(Collectors.toList());
                converted.put((String)p.getKey(), l);
            });
            return converted;
        }

        public String toString() {
            return "extractValuesInPropertiesMap";
        }
    }

    public final class MapPropertiesFilter
    implements Function<Traverser<Map<String, List<Property>>>, Map<String, List<Property>>>,
    Serializable {
        @Override
        public Map<String, List<Property>> apply(Traverser<Map<String, List<Property>>> mapTraverser) {
            Map<String, List<Property>> values = mapTraverser.get();
            HashMap<String, List<Property>> filtered = new HashMap<String, List<Property>>();
            values.entrySet().forEach(p -> {
                List l = ((List)p.getValue()).stream().filter(property -> {
                    if (property instanceof VertexProperty) {
                        Iterator itty = ((VertexProperty)property).values(PartitionStrategy.this.partitionKey);
                        return itty.hasNext() && PartitionStrategy.this.readPartitions.contains(itty.next());
                    }
                    return true;
                }).filter(property -> !property.key().equals(PartitionStrategy.this.partitionKey)).collect(Collectors.toList());
                if (l.size() > 0) {
                    filtered.put((String)p.getKey(), l);
                }
            });
            return filtered;
        }

        public String toString() {
            return "applyPartitionFilter";
        }
    }

    public final class PartitionKeyHider<A extends Property>
    implements Predicate<Traverser<A>>,
    Serializable {
        @Override
        public boolean test(Traverser<A> traverser) {
            return !((Property)traverser.get()).key().equals(PartitionStrategy.this.partitionKey);
        }

        public String toString() {
            return "remove(" + PartitionStrategy.this.partitionKey + ")";
        }
    }

    public final class TypeChecker<A>
    implements Predicate<Traverser<A>>,
    Serializable {
        final Class<? extends Element> toCheck;

        public TypeChecker(Class<? extends Element> toCheck) {
            this.toCheck = toCheck;
        }

        @Override
        public boolean test(Traverser traverser) {
            return this.toCheck.isAssignableFrom(traverser.get().getClass());
        }

        public String toString() {
            return "instanceOf(" + this.toCheck.getSimpleName() + ")";
        }
    }
}

