/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedEdge;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedElement;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedProperty;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class ComputerGraph
implements Graph {
    private ComputerVertex starVertex;
    private final Set<String> computeKeys;
    private State state;

    private ComputerGraph(State state, Vertex starVertex, Optional<VertexProgram<?>> vertexProgram) {
        this.state = state;
        this.computeKeys = vertexProgram.isPresent() ? vertexProgram.get().getVertexComputeKeys().stream().map(VertexComputeKey::getKey).collect(Collectors.toSet()) : Collections.emptySet();
        this.starVertex = new ComputerVertex(starVertex);
    }

    public static ComputerVertex vertexProgram(Vertex starVertex, VertexProgram vertexProgram) {
        return new ComputerGraph(State.VERTEX_PROGRAM, starVertex, Optional.of(vertexProgram)).getStarVertex();
    }

    public static ComputerVertex mapReduce(Vertex starVertex) {
        return new ComputerGraph(State.MAP_REDUCE, starVertex, Optional.empty()).getStarVertex();
    }

    public ComputerVertex getStarVertex() {
        return this.starVertex;
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphComputer compute() throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Transaction tx() {
        return this.starVertex.graph().tx();
    }

    @Override
    public Graph.Variables variables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Configuration configuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        throw new UnsupportedOperationException();
    }

    public class ComputerAdjacentVertex
    implements Vertex,
    WrappedVertex<Vertex> {
        private final Vertex adjacentVertex;

        public ComputerAdjacentVertex(Vertex adjacentVertex) {
            this.adjacentVertex = adjacentVertex;
        }

        @Override
        public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public Object id() {
            return this.adjacentVertex.id();
        }

        @Override
        public String label() {
            throw GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead();
        }

        @Override
        public Graph graph() {
            return ComputerGraph.this;
        }

        @Override
        public void remove() {
        }

        @Override
        public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        public int hashCode() {
            return this.adjacentVertex.hashCode();
        }

        public String toString() {
            return this.adjacentVertex.toString();
        }

        public boolean equals(Object other) {
            return this.adjacentVertex.equals(other);
        }

        @Override
        public Vertex getBaseVertex() {
            return this.adjacentVertex;
        }
    }

    public class ComputerProperty<V>
    implements Property<V>,
    WrappedProperty<Property<V>> {
        private final Property<V> property;

        public ComputerProperty(Property<V> property) {
            this.property = property;
        }

        @Override
        public String key() {
            return this.property.key();
        }

        @Override
        public V value() throws NoSuchElementException {
            return this.property.value();
        }

        @Override
        public boolean isPresent() {
            return this.property.isPresent();
        }

        @Override
        public Element element() {
            Element element = this.property.element();
            if (element instanceof Vertex) {
                return new ComputerVertex((Vertex)element);
            }
            if (element instanceof Edge) {
                return new ComputerEdge((Edge)element);
            }
            return new ComputerVertexProperty((VertexProperty)element);
        }

        @Override
        public void remove() {
            this.property.remove();
        }

        @Override
        public Property<V> getBaseProperty() {
            return this.property;
        }

        public String toString() {
            return this.property.toString();
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        public boolean equals(Object other) {
            return this.property.equals(other);
        }
    }

    public class ComputerVertexProperty<V>
    extends ComputerElement
    implements VertexProperty<V>,
    WrappedVertexProperty<VertexProperty<V>> {
        public ComputerVertexProperty(VertexProperty<V> vertexProperty) {
            super(vertexProperty);
        }

        @Override
        public String key() {
            return this.getBaseVertexProperty().key();
        }

        @Override
        public V value() throws NoSuchElementException {
            return this.getBaseVertexProperty().value();
        }

        @Override
        public boolean isPresent() {
            return this.getBaseVertexProperty().isPresent();
        }

        @Override
        public Vertex element() {
            return new ComputerVertex(this.getBaseVertexProperty().element());
        }

        @Override
        public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
            return IteratorUtils.map(super.properties(propertyKeys), property -> new ComputerProperty(property));
        }

        @Override
        public VertexProperty<V> getBaseVertexProperty() {
            return (VertexProperty)this.getBaseElement();
        }
    }

    public class ComputerEdge
    extends ComputerElement
    implements Edge,
    WrappedEdge<Edge> {
        public ComputerEdge(Edge edge) {
            super(edge);
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction) {
            if (direction.equals((Object)Direction.OUT)) {
                return IteratorUtils.of(this.outVertex());
            }
            if (direction.equals((Object)Direction.IN)) {
                return IteratorUtils.of(this.inVertex());
            }
            return IteratorUtils.of(this.outVertex(), this.inVertex());
        }

        @Override
        public Vertex outVertex() {
            return this.getBaseEdge().outVertex().equals(ComputerGraph.this.starVertex) ? ComputerGraph.this.starVertex : new ComputerAdjacentVertex(this.getBaseEdge().outVertex());
        }

        @Override
        public Vertex inVertex() {
            return this.getBaseEdge().inVertex().equals(ComputerGraph.this.starVertex) ? ComputerGraph.this.starVertex : new ComputerAdjacentVertex(this.getBaseEdge().inVertex());
        }

        @Override
        public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
            return IteratorUtils.map(super.properties(propertyKeys), property -> new ComputerProperty(property));
        }

        @Override
        public Edge getBaseEdge() {
            return (Edge)this.getBaseElement();
        }
    }

    public class ComputerVertex
    extends ComputerElement
    implements Vertex,
    WrappedVertex<Vertex> {
        public ComputerVertex(Vertex vertex) {
            super(vertex);
        }

        @Override
        public <V> VertexProperty<V> property(String key) {
            return new ComputerVertexProperty(this.getBaseVertex().property(key));
        }

        @Override
        public <V> VertexProperty<V> property(String key, V value) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce();
            }
            if (!ComputerGraph.this.computeKeys.contains(key)) {
                throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey(key);
            }
            return new ComputerVertexProperty(this.getBaseVertex().property(key, (Object)value));
        }

        @Override
        public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce();
            }
            if (!ComputerGraph.this.computeKeys.contains(key)) {
                throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey(key);
            }
            return new ComputerVertexProperty<V>(this.getBaseVertex().property(key, value, keyValues));
        }

        @Override
        public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce();
            }
            if (!ComputerGraph.this.computeKeys.contains(key)) {
                throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey(key);
            }
            return new ComputerVertexProperty<V>(this.getBaseVertex().property(cardinality, key, value, keyValues));
        }

        @Override
        public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce();
            }
            return new ComputerEdge(this.getBaseVertex().addEdge(label, inVertex, keyValues));
        }

        @Override
        public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce();
            }
            return IteratorUtils.map(this.getBaseVertex().edges(direction, edgeLabels), x$0 -> new ComputerEdge((Edge)x$0));
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce();
            }
            return IteratorUtils.map(this.getBaseVertex().vertices(direction, edgeLabels), v -> v.equals(ComputerGraph.this.starVertex) ? ComputerGraph.this.starVertex : new ComputerAdjacentVertex((Vertex)v));
        }

        @Override
        public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
            return IteratorUtils.map(super.properties(propertyKeys), property -> new ComputerVertexProperty((VertexProperty)property));
        }

        @Override
        public Vertex getBaseVertex() {
            return (Vertex)this.getBaseElement();
        }
    }

    public class ComputerElement
    implements Element,
    WrappedElement<Element> {
        private final Element element;

        public ComputerElement(Element element) {
            this.element = element;
        }

        @Override
        public Object id() {
            return this.element.id();
        }

        @Override
        public String label() {
            return this.element.label();
        }

        @Override
        public Graph graph() {
            return ComputerGraph.this;
        }

        @Override
        public Set<String> keys() {
            return this.element.keys().stream().filter(key -> !ComputerGraph.this.computeKeys.contains(key)).collect(Collectors.toSet());
        }

        @Override
        public <V> Property<V> property(String key) {
            return new ComputerProperty(this.element.property(key));
        }

        @Override
        public <V> Property<V> property(String key, V value) {
            if (ComputerGraph.this.state.equals((Object)State.MAP_REDUCE)) {
                throw GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce();
            }
            return new ComputerProperty<V>(this.element.property(key, value));
        }

        @Override
        public <V> V value(String key) throws NoSuchElementException {
            return this.element.value(key);
        }

        @Override
        public void remove() {
            this.element.remove();
        }

        @Override
        public <V> Iterator<? extends Property<V>> properties(String ... propertyKeys) {
            return IteratorUtils.filter(this.element.properties(propertyKeys), property -> !ComputerGraph.this.computeKeys.contains(property.key()));
        }

        @Override
        public <V> Iterator<V> values(String ... propertyKeys) {
            return IteratorUtils.map(this.properties(propertyKeys), property -> property.value());
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public String toString() {
            return this.element.toString();
        }

        public boolean equals(Object other) {
            return this.element.equals(other);
        }

        @Override
        public Element getBaseElement() {
            return this.element;
        }
    }

    private static enum State {
        VERTEX_PROGRAM,
        MAP_REDUCE;

    }
}

