/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class JavaTimeSerializersV1d0 {
    private JavaTimeSerializersV1d0() {
    }

    static final class ZoneOffsetJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<ZoneOffset> {
        public ZoneOffsetJacksonDeserializer() {
            super(ZoneOffset.class);
        }

        @Override
        public ZoneOffset parse(String val) {
            return ZoneOffset.of(val);
        }
    }

    static final class ZoneOffsetJacksonSerializer
    extends AbstractJavaTimeSerializer<ZoneOffset> {
        public ZoneOffsetJacksonSerializer() {
            super(ZoneOffset.class);
        }
    }

    static final class ZonedDateTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<ZonedDateTime> {
        public ZonedDateTimeJacksonDeserializer() {
            super(ZonedDateTime.class);
        }

        @Override
        public ZonedDateTime parse(String val) {
            return ZonedDateTime.parse(val);
        }
    }

    static final class ZonedDateTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<ZonedDateTime> {
        public ZonedDateTimeJacksonSerializer() {
            super(ZonedDateTime.class);
        }
    }

    static final class YearMonthJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<YearMonth> {
        public YearMonthJacksonDeserializer() {
            super(YearMonth.class);
        }

        @Override
        public YearMonth parse(String val) {
            return YearMonth.parse(val);
        }
    }

    static final class YearMonthJacksonSerializer
    extends AbstractJavaTimeSerializer<YearMonth> {
        public YearMonthJacksonSerializer() {
            super(YearMonth.class);
        }
    }

    static final class YearJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Year> {
        public YearJacksonDeserializer() {
            super(Year.class);
        }

        @Override
        public Year parse(String val) {
            return Year.parse(val);
        }
    }

    static final class YearJacksonSerializer
    extends AbstractJavaTimeSerializer<Year> {
        public YearJacksonSerializer() {
            super(Year.class);
        }
    }

    static final class PeriodJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Period> {
        public PeriodJacksonDeserializer() {
            super(Period.class);
        }

        @Override
        public Period parse(String val) {
            return Period.parse(val);
        }
    }

    static final class PeriodJacksonSerializer
    extends AbstractJavaTimeSerializer<Period> {
        public PeriodJacksonSerializer() {
            super(Period.class);
        }
    }

    static final class OffsetTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<OffsetTime> {
        public OffsetTimeJacksonDeserializer() {
            super(OffsetTime.class);
        }

        @Override
        public OffsetTime parse(String val) {
            return OffsetTime.parse(val);
        }
    }

    static final class OffsetTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<OffsetTime> {
        public OffsetTimeJacksonSerializer() {
            super(OffsetTime.class);
        }
    }

    static final class OffsetDateTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<OffsetDateTime> {
        public OffsetDateTimeJacksonDeserializer() {
            super(OffsetDateTime.class);
        }

        @Override
        public OffsetDateTime parse(String val) {
            return OffsetDateTime.parse(val);
        }
    }

    static final class OffsetDateTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<OffsetDateTime> {
        public OffsetDateTimeJacksonSerializer() {
            super(OffsetDateTime.class);
        }
    }

    static final class MonthDayJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<MonthDay> {
        public MonthDayJacksonDeserializer() {
            super(MonthDay.class);
        }

        @Override
        public MonthDay parse(String val) {
            return MonthDay.parse(val);
        }
    }

    static final class MonthDayJacksonSerializer
    extends AbstractJavaTimeSerializer<MonthDay> {
        public MonthDayJacksonSerializer() {
            super(MonthDay.class);
        }
    }

    static final class LocalTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalTime> {
        public LocalTimeJacksonDeserializer() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime parse(String val) {
            return LocalTime.parse(val);
        }
    }

    static final class LocalTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalTime> {
        public LocalTimeJacksonSerializer() {
            super(LocalTime.class);
        }
    }

    static final class LocalDateTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalDateTime> {
        public LocalDateTimeJacksonDeserializer() {
            super(LocalDateTime.class);
        }

        @Override
        public LocalDateTime parse(String val) {
            return LocalDateTime.parse(val);
        }
    }

    static final class LocalDateTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalDateTime> {
        public LocalDateTimeJacksonSerializer() {
            super(LocalDateTime.class);
        }
    }

    static final class LocalDateJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalDate> {
        public LocalDateJacksonDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate parse(String val) {
            return LocalDate.parse(val);
        }
    }

    static final class LocalDateJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalDate> {
        public LocalDateJacksonSerializer() {
            super(LocalDate.class);
        }
    }

    static final class InstantJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Instant> {
        public InstantJacksonDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant parse(String val) {
            return Instant.parse(val);
        }
    }

    static final class InstantJacksonSerializer
    extends AbstractJavaTimeSerializer<Instant> {
        public InstantJacksonSerializer() {
            super(Instant.class);
        }
    }

    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        public DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        public DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        public AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public abstract T parse(String var1);

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.getText().equals("value")) {
                throw new IOException(String.format("Invalid format for %s - expecting '%s' with a text value in ISO-8061 format", this._valueClass.getSimpleName(), "value"));
            }
            return this.parse(jsonParser.nextTextValue());
        }
    }

    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        public AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }

        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefixForObject(value, gen);
            gen.writeStringField("value", value.toString());
            typeSer.writeTypeSuffixForObject(value, gen);
        }
    }
}

