/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

public interface RemoteConnection
extends AutoCloseable {
    public static final String GREMLIN_REMOTE = "gremlin.remote.";
    public static final String GREMLIN_REMOTE_CONNECTION_CLASS = "gremlin.remote.remoteConnectionClass";

    @Deprecated
    public <E> Iterator<Traverser.Admin<E>> submit(Traversal<?, E> var1) throws RemoteConnectionException;

    @Deprecated
    public <E> RemoteTraversal<?, E> submit(Bytecode var1) throws RemoteConnectionException;

    default public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        CompletableFuture promise = new CompletableFuture();
        try {
            promise.complete(this.submit(bytecode));
        }
        catch (Exception t) {
            promise.completeExceptionally(t);
        }
        return promise;
    }

    public static RemoteConnection from(Configuration conf) {
        if (!conf.containsKey(GREMLIN_REMOTE_CONNECTION_CLASS)) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remote.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz = Class.forName(conf.getString(GREMLIN_REMOTE_CONNECTION_CLASS)).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz.getConstructor(Configuration.class);
            return ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

