/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;

public final class IoRegistryHelper {
    private IoRegistryHelper() {
    }

    public static List<IoRegistry> createRegistries(List<Object> registryNamesClassesOrInstances) {
        if (registryNamesClassesOrInstances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IoRegistry> registries = new ArrayList<IoRegistry>();
        for (Object object : registryNamesClassesOrInstances) {
            if (object instanceof IoRegistry) {
                registries.add((IoRegistry)object);
                continue;
            }
            if (object instanceof String || object instanceof Class) {
                try {
                    Class<?> clazz = object instanceof String ? Class.forName((String)object) : (Class<?>)object;
                    Method instanceMethod = null;
                    try {
                        instanceMethod = clazz.getDeclaredMethod("instance", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            instanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (null != instanceMethod && IoRegistry.class.isAssignableFrom(instanceMethod.getReturnType())) {
                        registries.add((IoRegistry)instanceMethod.invoke(null, new Object[0]));
                        continue;
                    }
                    registries.add((IoRegistry)clazz.newInstance());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            throw new IllegalArgumentException("The provided registry object can not be resolved to an instance: " + object);
        }
        return registries;
    }

    public static List<IoRegistry> createRegistries(Configuration configuration) {
        if (configuration.containsKey("gremlin.io.registry")) {
            Object property = configuration.getProperty("gremlin.io.registry");
            if (property instanceof IoRegistry) {
                return Collections.singletonList((IoRegistry)property);
            }
            if (property instanceof List) {
                return IoRegistryHelper.createRegistries((List)property);
            }
            if (property instanceof String) {
                return IoRegistryHelper.createRegistries(Arrays.asList(((String)property).split(",")));
            }
            throw new IllegalArgumentException("The provided registry object can not be resolved to an instance: " + property);
        }
        return Collections.emptyList();
    }
}

