/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.HasNextStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class ConnectiveStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private static final ConnectiveStrategy INSTANCE = new ConnectiveStrategy();

    private ConnectiveStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.hasStepOfAssignableClass(ConnectiveStep.class, traversal)) {
            ConnectiveStrategy.processConnectiveMarker(traversal);
        }
    }

    private static boolean legalCurrentStep(Step<?, ?> step) {
        return !(step instanceof EmptyStep) && !(step instanceof ProfileSideEffectStep) && !(step instanceof HasNextStep) && !(step instanceof ComputerAwareStep.EndStep) && (!(step instanceof StartStep) || StartStep.isVariableStartStep(step)) && !GraphStep.isStartStep(step);
    }

    private static void processConnectiveMarker(Traversal.Admin<?, ?> traversal) {
        ConnectiveStrategy.processConjunctionMarker(OrStep.class, traversal);
        ConnectiveStrategy.processConjunctionMarker(AndStep.class, traversal);
    }

    private static void processConjunctionMarker(Class<? extends ConnectiveStep> markerClass, Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(markerClass, traversal).stream().filter(conjunctionStep -> conjunctionStep.getLocalChildren().isEmpty()).findFirst().ifPresent(connectiveStep -> {
            Step<Object, Object> currentStep = connectiveStep.getNextStep();
            Traversal.Admin rightTraversal = __.start().asAdmin();
            if (!connectiveStep.getLabels().isEmpty()) {
                StartStep startStep = new StartStep(rightTraversal);
                Set<String> conjunctionLabels = connectiveStep.getLabels();
                conjunctionLabels.forEach(startStep::addLabel);
                conjunctionLabels.forEach(label -> connectiveStep.removeLabel((String)label));
                rightTraversal.addStep(startStep);
            }
            while (ConnectiveStrategy.legalCurrentStep(currentStep)) {
                Step<?, ?> nextStep = currentStep.getNextStep();
                rightTraversal.addStep(currentStep);
                traversal.removeStep(currentStep);
                currentStep = nextStep;
            }
            ConnectiveStrategy.processConnectiveMarker(rightTraversal);
            currentStep = connectiveStep.getPreviousStep();
            Traversal.Admin leftTraversal = __.start().asAdmin();
            while (ConnectiveStrategy.legalCurrentStep(currentStep)) {
                Step<?, Object> previousStep = currentStep.getPreviousStep();
                leftTraversal.addStep(0, currentStep);
                traversal.removeStep(currentStep);
                currentStep = previousStep;
            }
            ConnectiveStrategy.processConnectiveMarker(leftTraversal);
            if (connectiveStep instanceof AndStep) {
                TraversalHelper.replaceStep(connectiveStep, new AndStep(traversal, leftTraversal, rightTraversal), traversal);
            } else {
                TraversalHelper.replaceStep(connectiveStep, new OrStep(traversal, leftTraversal, rightTraversal), traversal);
            }
        });
    }

    public static ConnectiveStrategy instance() {
        return INSTANCE;
    }
}

