/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class SampleLocalStep<S>
extends MapStep<S, S> {
    private static final Random RANDOM = new Random();
    private final int amountToSample;

    public SampleLocalStep(Traversal.Admin traversal, int amountToSample) {
        super(traversal);
        this.amountToSample = amountToSample;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        if (start instanceof Map) {
            return this.mapMap((Map)start);
        }
        if (start instanceof Collection) {
            return this.mapCollection((Collection)start);
        }
        return (S)start;
    }

    private S mapCollection(Collection collection) {
        if (collection.size() <= this.amountToSample) {
            return (S)collection;
        }
        ArrayList original = new ArrayList(collection);
        ArrayList target = new ArrayList();
        while (target.size() < this.amountToSample) {
            target.add(original.remove(RANDOM.nextInt(original.size())));
        }
        return (S)target;
    }

    private S mapMap(Map map) {
        if (map.size() <= this.amountToSample) {
            return (S)map;
        }
        ArrayList original = new ArrayList(map.entrySet());
        LinkedHashMap target = new LinkedHashMap(this.amountToSample);
        while (target.size() < this.amountToSample) {
            Map.Entry entry = (Map.Entry)original.remove(RANDOM.nextInt(original.size()));
            target.put(entry.getKey(), entry.getValue());
        }
        return (S)target;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.amountToSample;
    }
}

