/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class DropStep<S>
extends FilterStep<S>
implements Mutating<Event> {
    private CallbackRegistry<Event> callbackRegistry;

    public DropStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        Object s = traverser.get();
        if (s instanceof Element) {
            Element toRemove = (Element)s;
            if (this.callbackRegistry != null) {
                Event removeEvent;
                EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                if (s instanceof Vertex) {
                    removeEvent = new Event.VertexRemovedEvent(eventStrategy.detach((Vertex)s));
                } else if (s instanceof Edge) {
                    removeEvent = new Event.EdgeRemovedEvent(eventStrategy.detach((Edge)s));
                } else if (s instanceof VertexProperty) {
                    removeEvent = new Event.VertexPropertyRemovedEvent(eventStrategy.detach((VertexProperty)s));
                } else {
                    throw new IllegalStateException("The incoming object is not removable: " + s);
                }
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
            }
            toRemove.remove();
        } else if (s instanceof Property) {
            Property toRemove = (Property)s;
            if (this.callbackRegistry != null) {
                Event.ElementPropertyEvent removeEvent;
                EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                if (toRemove.element() instanceof Edge) {
                    removeEvent = new Event.EdgePropertyRemovedEvent(eventStrategy.detach((Edge)toRemove.element()), eventStrategy.detach(toRemove));
                } else if (toRemove.element() instanceof VertexProperty) {
                    removeEvent = new Event.VertexPropertyPropertyRemovedEvent(eventStrategy.detach((VertexProperty)toRemove.element()), eventStrategy.detach(toRemove));
                } else {
                    throw new IllegalStateException("The incoming object is not removable: " + s);
                }
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
            }
            toRemove.remove();
        } else {
            throw new IllegalStateException("The incoming object is not removable: " + s);
        }
        return false;
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event>();
        }
        return this.callbackRegistry;
    }

    @Override
    public void addPropertyMutations(Object ... keyValues) {
    }
}

