/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.branch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public class BranchStep<S, E, M>
extends ComputerAwareStep<S, E>
implements TraversalOptionParent<M, S, E> {
    protected Traversal.Admin<S, M> branchTraversal;
    protected Map<Object, List<Traversal.Admin<S, E>>> traversalOptions = new HashMap<Object, List<Traversal.Admin<S, E>>>();
    private boolean first = true;
    private boolean hasBarrier = false;

    public BranchStep(Traversal.Admin traversal) {
        super(traversal);
    }

    public void setBranchTraversal(Traversal.Admin<S, M> branchTraversal) {
        this.branchTraversal = this.integrateChild(branchTraversal);
    }

    @Override
    public void addGlobalChildOption(M pickToken, Traversal.Admin<S, E> traversalOption) {
        Object pickTokenKey = PickTokenKey.make(pickToken);
        if (this.traversalOptions.containsKey(pickTokenKey)) {
            this.traversalOptions.get(pickTokenKey).add(traversalOption);
        } else {
            this.traversalOptions.put(pickTokenKey, new ArrayList<Traversal.Admin<S, E>>(Collections.singletonList(traversalOption)));
        }
        if (TraversalHelper.hasStepOfAssignableClass(ReducingBarrierStep.class, traversalOption)) {
            traversalOption.addStep(0, new IdentityStep(traversalOption));
        }
        traversalOption.addStep(new ComputerAwareStep.EndStep(traversalOption));
        if (!this.hasBarrier && !TraversalHelper.getStepsOfAssignableClassRecursively(Barrier.class, traversalOption).isEmpty()) {
            this.hasBarrier = true;
        }
        this.integrateChild(traversalOption);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public List<Traversal.Admin<S, E>> getGlobalChildren() {
        return Collections.unmodifiableList(this.traversalOptions.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public List<Traversal.Admin<S, M>> getLocalChildren() {
        return Collections.singletonList(this.branchTraversal);
    }

    @Override
    protected Iterator<Traverser.Admin<E>> standardAlgorithm() {
        block0: while (true) {
            if (!this.first) {
                for (List<Traversal.Admin<S, E>> options : this.traversalOptions.values()) {
                    for (Traversal.Admin<S, E> option : options) {
                        if (!option.getStartStep().hasNext() || !option.hasNext()) continue;
                        return option.getEndStep();
                    }
                }
            }
            this.first = false;
            if (this.hasBarrier) {
                if (!this.starts.hasNext()) {
                    throw FastNoSuchElementException.instance();
                }
                while (true) {
                    if (!this.starts.hasNext()) continue block0;
                    this.applyCurrentTraverser((Traverser.Admin<S>)this.starts.next());
                }
            }
            this.applyCurrentTraverser((Traverser.Admin<S>)this.starts.next());
        }
    }

    private void applyCurrentTraverser(Traverser.Admin<S> start) {
        List<Traversal.Admin<S, E>> anyBranch;
        List<Traversal.Admin<S, Traversal.Admin<S, E>>> branch;
        Object choice = PickTokenKey.make(TraversalUtil.apply(start, this.branchTraversal));
        List<Traversal.Admin<S, Traversal.Admin<S, E>>> list = branch = this.traversalOptions.containsKey(choice) ? this.traversalOptions.get(choice) : this.traversalOptions.get((Object)TraversalOptionParent.Pick.none);
        if (null != branch) {
            branch.forEach(traversal -> traversal.addStart(start.split()));
        }
        if (choice != TraversalOptionParent.Pick.any && null != (anyBranch = this.traversalOptions.get((Object)TraversalOptionParent.Pick.any))) {
            anyBranch.forEach(traversal -> traversal.addStart(start.split()));
        }
    }

    @Override
    protected Iterator<Traverser.Admin<E>> computerAlgorithm() {
        List<Traversal.Admin<S, E>> anyBranch;
        List<Traversal.Admin<S, Traversal.Admin<S, E>>> branch;
        ArrayList ends = new ArrayList();
        Object start = this.starts.next();
        Object choice = PickTokenKey.make(TraversalUtil.apply(start, this.branchTraversal));
        List<Traversal.Admin<S, Traversal.Admin<S, E>>> list = branch = this.traversalOptions.containsKey(choice) ? this.traversalOptions.get(choice) : this.traversalOptions.get((Object)TraversalOptionParent.Pick.none);
        if (null != branch) {
            branch.forEach(arg_0 -> BranchStep.lambda$computerAlgorithm$2((Traverser.Admin)start, ends, arg_0));
        }
        if (choice != TraversalOptionParent.Pick.any && null != (anyBranch = this.traversalOptions.get((Object)TraversalOptionParent.Pick.any))) {
            anyBranch.forEach(arg_0 -> BranchStep.lambda$computerAlgorithm$3((Traverser.Admin)start, ends, arg_0));
        }
        return ends.iterator();
    }

    @Override
    public BranchStep<S, E, M> clone() {
        BranchStep clone = (BranchStep)super.clone();
        clone.traversalOptions = new HashMap<Object, List<Traversal.Admin<S, E>>>(this.traversalOptions.size());
        for (Map.Entry<Object, List<Traversal.Admin<S, E>>> entry : this.traversalOptions.entrySet()) {
            List traversals = entry.getValue();
            if (traversals.size() <= 0) continue;
            List clonedTraversals = clone.traversalOptions.compute(entry.getKey(), (k, v) -> v == null ? new ArrayList(traversals.size()) : v);
            for (Traversal.Admin<S, E> traversal : traversals) {
                clonedTraversals.add(traversal.clone());
            }
        }
        clone.branchTraversal = this.branchTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.branchTraversal);
        this.traversalOptions.values().stream().flatMap(Collection::stream).forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.traversalOptions != null) {
            result ^= this.traversalOptions.hashCode();
        }
        if (this.branchTraversal != null) {
            result ^= this.branchTraversal.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.branchTraversal, this.traversalOptions);
    }

    @Override
    public void reset() {
        super.reset();
        this.getGlobalChildren().forEach(Traversal.Admin::reset);
        this.first = true;
    }

    private static /* synthetic */ void lambda$computerAlgorithm$3(Traverser.Admin start, List ends, Traversal.Admin traversal) {
        Traverser.Admin split = start.split();
        split.setStepId(traversal.getStartStep().getId());
        ends.add(split);
    }

    private static /* synthetic */ void lambda$computerAlgorithm$2(Traverser.Admin start, List ends, Traversal.Admin traversal) {
        Traverser.Admin split = start.split();
        split.setStepId(traversal.getStartStep().getId());
        ends.add(split);
    }

    private static class PickTokenKey {
        final Number number;

        private PickTokenKey(Number number) {
            this.number = number;
        }

        static Object make(Object value) {
            return value instanceof Number ? new PickTokenKey((Number)value) : value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickTokenKey other = (PickTokenKey)o;
            return 0 == NumberHelper.compare(this.number, other.number);
        }

        public int hashCode() {
            return this.number.hashCode();
        }

        public String toString() {
            return this.number.toString();
        }
    }
}

