/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public interface VertexProgram<M>
extends Cloneable {
    public static final String VERTEX_PROGRAM = "gremlin.vertexProgram";

    default public void storeState(Configuration configuration) {
        configuration.setProperty(VERTEX_PROGRAM, (Object)this.getClass().getName());
    }

    default public void loadState(Graph graph, Configuration configuration) {
    }

    public void setup(Memory var1);

    public void execute(Vertex var1, Messenger<M> var2, Memory var3);

    public boolean terminate(Memory var1);

    default public void workerIterationStart(Memory memory) {
    }

    default public void workerIterationEnd(Memory memory) {
    }

    default public Set<VertexComputeKey> getVertexComputeKeys() {
        return Collections.emptySet();
    }

    default public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return Collections.emptySet();
    }

    default public Optional<MessageCombiner<M>> getMessageCombiner() {
        return Optional.empty();
    }

    public Set<MessageScope> getMessageScopes(Memory var1);

    default public Set<MapReduce> getMapReducers() {
        return Collections.emptySet();
    }

    default public Set<TraverserRequirement> getTraverserRequirements() {
        return Collections.emptySet();
    }

    public VertexProgram<M> clone();

    public GraphComputer.ResultGraph getPreferredResultGraph();

    public GraphComputer.Persist getPreferredPersist();

    public static <V extends VertexProgram> V createVertexProgram(Graph graph, Configuration configuration) {
        try {
            Class<?> vertexProgramClass = Class.forName(configuration.getString(VERTEX_PROGRAM));
            Constructor<?> constructor = vertexProgramClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            VertexProgram vertexProgram = (VertexProgram)constructor.newInstance(new Object[0]);
            vertexProgram.loadState(graph, configuration);
            return (V)vertexProgram;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    default public Features getFeatures() {
        return new Features(){};
    }

    public static interface Features {
        default public boolean requiresGlobalMessageScopes() {
            return false;
        }

        default public boolean requiresLocalMessageScopes() {
            return false;
        }

        default public boolean requiresVertexAddition() {
            return false;
        }

        default public boolean requiresVertexRemoval() {
            return false;
        }

        default public boolean requiresVertexPropertyAddition() {
            return false;
        }

        default public boolean requiresVertexPropertyRemoval() {
            return false;
        }

        default public boolean requiresEdgeAddition() {
            return false;
        }

        default public boolean requiresEdgeRemoval() {
            return false;
        }

        default public boolean requiresEdgePropertyAddition() {
            return false;
        }

        default public boolean requiresEdgePropertyRemoval() {
            return false;
        }
    }

    public static interface Builder {
        public Builder configure(Object ... var1);

        public <P extends VertexProgram> P create(Graph var1);

        default public <P extends VertexProgram> P create() {
            return this.create(null);
        }
    }
}

