/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SideEffectIterator
implements Iterator<Object> {
    private final Iterator<Object> sideEffectIterator;
    private final String sideEffectKey;
    private final String sideEffectAggregator;

    public SideEffectIterator(Object sideEffect, String sideEffectKey) {
        this.sideEffectKey = sideEffectKey;
        this.sideEffectAggregator = this.getAggregatorType(sideEffect);
        this.sideEffectIterator = sideEffect instanceof BulkSet ? new BulkSetIterator((BulkSet<Object>)((BulkSet)sideEffect)) : IteratorUtils.asIterator((Object)sideEffect);
    }

    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    public String getSideEffectAggregator() {
        return this.sideEffectAggregator;
    }

    @Override
    public boolean hasNext() {
        return this.sideEffectIterator.hasNext();
    }

    @Override
    public Object next() {
        return this.sideEffectIterator.next();
    }

    private String getAggregatorType(Object o) {
        if (o instanceof BulkSet) {
            return "bulkset";
        }
        if (o instanceof Set) {
            return "set";
        }
        if (o instanceof Iterable || o instanceof Iterator) {
            return "list";
        }
        if (o instanceof Map) {
            return "map";
        }
        return "none";
    }

    static class BulkSetIterator
    implements Iterator {
        private final Iterator<Map.Entry<Object, Long>> itty;

        public BulkSetIterator(BulkSet<Object> bulkSet) {
            this.itty = bulkSet.asBulk().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itty.hasNext();
        }

        public Object next() {
            Map.Entry<Object, Long> entry = this.itty.next();
            return new DefaultRemoteTraverser(entry.getKey(), entry.getValue().longValue());
        }
    }
}

