/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerContext {
    private static final Logger logger = LoggerFactory.getLogger(ResponseHandlerContext.class);
    private final Context context;
    private final AtomicBoolean finalResponseWritten = new AtomicBoolean();

    public ResponseHandlerContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void writeAndFlush(ResponseMessage message) {
        this.writeAndFlush(message.getStatus().getCode(), message);
    }

    public void writeAndFlush(ResponseStatusCode code, Object responseMessage) {
        boolean messageIsFinal = code.isFinalResponse();
        if (this.finalResponseWritten.compareAndSet(false, messageIsFinal)) {
            this.context.getChannelHandlerContext().writeAndFlush(responseMessage);
        } else {
            String logMessage = String.format("Another final response message was already written for request %s, ignoring response code: %s", this.context.getRequestMessage().getRequestId(), code);
            logger.warn(logMessage);
        }
    }
}

