'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var previousTimestamp = void 0;

var methods = {
  beginTiming: function beginTiming() {
    previousTimestamp = getTimestamp();
  },

  clearInterval: clearInterval.bind(global),
  clearTimeout: clearTimeout.bind(global),
  Date: Date,
  endTiming: function endTiming() {
    return getTimestamp() - previousTimestamp;
  },

  setInterval: setInterval.bind(global),
  setTimeout: setTimeout.bind(global)
};

if (typeof setImmediate !== 'undefined') {
  methods.setImmediate = setImmediate.bind(global);
  methods.clearImmediate = clearImmediate.bind(global);
}

function getTimestamp() {
  return new methods.Date().getTime();
}

exports.default = methods;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy90aW1lLmpzIl0sIm5hbWVzIjpbInByZXZpb3VzVGltZXN0YW1wIiwibWV0aG9kcyIsImJlZ2luVGltaW5nIiwiZ2V0VGltZXN0YW1wIiwiY2xlYXJJbnRlcnZhbCIsImJpbmQiLCJnbG9iYWwiLCJjbGVhclRpbWVvdXQiLCJEYXRlIiwiZW5kVGltaW5nIiwic2V0SW50ZXJ2YWwiLCJzZXRUaW1lb3V0Iiwic2V0SW1tZWRpYXRlIiwiY2xlYXJJbW1lZGlhdGUiLCJnZXRUaW1lIl0sIm1hcHBpbmdzIjoiOzs7OztBQUFBLElBQUlBLDBCQUFKOztBQUVBLElBQU1DLFVBQVU7QUFDZEMsYUFEYyx5QkFDQTtBQUNaRix3QkFBb0JHLGNBQXBCO0FBQ0QsR0FIYTs7QUFJZEMsaUJBQWVBLGNBQWNDLElBQWQsQ0FBbUJDLE1BQW5CLENBSkQ7QUFLZEMsZ0JBQWNBLGFBQWFGLElBQWIsQ0FBa0JDLE1BQWxCLENBTEE7QUFNZEUsWUFOYztBQU9kQyxXQVBjLHVCQU9GO0FBQ1YsV0FBT04saUJBQWlCSCxpQkFBeEI7QUFDRCxHQVRhOztBQVVkVSxlQUFhQSxZQUFZTCxJQUFaLENBQWlCQyxNQUFqQixDQVZDO0FBV2RLLGNBQVlBLFdBQVdOLElBQVgsQ0FBZ0JDLE1BQWhCO0FBWEUsQ0FBaEI7O0FBY0EsSUFBSSxPQUFPTSxZQUFQLEtBQXdCLFdBQTVCLEVBQXlDO0FBQ3ZDWCxVQUFRVyxZQUFSLEdBQXVCQSxhQUFhUCxJQUFiLENBQWtCQyxNQUFsQixDQUF2QjtBQUNBTCxVQUFRWSxjQUFSLEdBQXlCQSxlQUFlUixJQUFmLENBQW9CQyxNQUFwQixDQUF6QjtBQUNEOztBQUVELFNBQVNILFlBQVQsR0FBd0I7QUFDdEIsU0FBTyxJQUFJRixRQUFRTyxJQUFaLEdBQW1CTSxPQUFuQixFQUFQO0FBQ0Q7O2tCQUVjYixPIiwiZmlsZSI6InRpbWUuanMiLCJzb3VyY2VzQ29udGVudCI6WyJsZXQgcHJldmlvdXNUaW1lc3RhbXBcblxuY29uc3QgbWV0aG9kcyA9IHtcbiAgYmVnaW5UaW1pbmcoKSB7XG4gICAgcHJldmlvdXNUaW1lc3RhbXAgPSBnZXRUaW1lc3RhbXAoKVxuICB9LFxuICBjbGVhckludGVydmFsOiBjbGVhckludGVydmFsLmJpbmQoZ2xvYmFsKSxcbiAgY2xlYXJUaW1lb3V0OiBjbGVhclRpbWVvdXQuYmluZChnbG9iYWwpLFxuICBEYXRlLFxuICBlbmRUaW1pbmcoKSB7XG4gICAgcmV0dXJuIGdldFRpbWVzdGFtcCgpIC0gcHJldmlvdXNUaW1lc3RhbXBcbiAgfSxcbiAgc2V0SW50ZXJ2YWw6IHNldEludGVydmFsLmJpbmQoZ2xvYmFsKSxcbiAgc2V0VGltZW91dDogc2V0VGltZW91dC5iaW5kKGdsb2JhbClcbn1cblxuaWYgKHR5cGVvZiBzZXRJbW1lZGlhdGUgIT09ICd1bmRlZmluZWQnKSB7XG4gIG1ldGhvZHMuc2V0SW1tZWRpYXRlID0gc2V0SW1tZWRpYXRlLmJpbmQoZ2xvYmFsKVxuICBtZXRob2RzLmNsZWFySW1tZWRpYXRlID0gY2xlYXJJbW1lZGlhdGUuYmluZChnbG9iYWwpXG59XG5cbmZ1bmN0aW9uIGdldFRpbWVzdGFtcCgpIHtcbiAgcmV0dXJuIG5ldyBtZXRob2RzLkRhdGUoKS5nZXRUaW1lKClcbn1cblxuZXhwb3J0IGRlZmF1bHQgbWV0aG9kc1xuIl19