/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkloading;

import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class IncrementalBulkLoader
implements BulkLoader {
    private String bulkLoaderVertexId = "bulkLoader.vertex.id";
    private boolean keepOriginalIds = true;
    private boolean userSuppliedIds = false;

    @Override
    public Vertex getOrCreateVertex(Vertex vertex, Graph graph, GraphTraversalSource g) {
        GraphTraversal<Vertex, Vertex> iterator;
        GraphTraversal<Vertex, Vertex> graphTraversal = iterator = this.useUserSuppliedIds() ? g.V(new Object[0]).hasId(vertex.id(), new Object[0]) : g.V(new Object[0]).has(vertex.label(), this.getVertexIdProperty(), vertex.id().toString());
        return iterator.hasNext() ? (Vertex)iterator.next() : (this.useUserSuppliedIds() ? (Vertex)g.addV(vertex.label()).property(T.id, vertex.id(), new Object[0]).next() : (Vertex)g.addV(vertex.label()).property(this.getVertexIdProperty(), (Object)vertex.id().toString(), new Object[0]).next());
    }

    @Override
    public Edge getOrCreateEdge(Edge edge, Vertex outVertex, Vertex inVertex, Graph graph, GraphTraversalSource g) {
        Edge e;
        GraphTraversal<Vertex, Edge> t = g.V(outVertex).outE(edge.label()).filter(__.inV().is(inVertex));
        if (t.hasNext()) {
            e = (Edge)t.next();
            edge.properties(new String[0]).forEachRemaining(property -> {
                Property existing = e.property(property.key());
                if (!existing.isPresent() || !existing.value().equals(property.value())) {
                    e.property(property.key(), property.value());
                }
            });
        } else {
            e = this.createEdge(edge, outVertex, inVertex, graph, g);
        }
        return e;
    }

    @Override
    public VertexProperty getOrCreateVertexProperty(VertexProperty<?> property, Vertex vertex, Graph graph, GraphTraversalSource g) {
        Property existing = vertex.property(property.key());
        if (!existing.isPresent()) {
            return this.createVertexProperty(property, vertex, graph, g);
        }
        Property vp = !existing.value().equals(property.value()) ? vertex.property(property.key(), property.value()) : existing;
        property.properties(new String[0]).forEachRemaining(arg_0 -> IncrementalBulkLoader.lambda$getOrCreateVertexProperty$1((VertexProperty)vp, arg_0));
        return vp;
    }

    @Override
    public Vertex getVertex(Vertex vertex, Graph graph, GraphTraversalSource g) {
        return this.useUserSuppliedIds() ? this.getVertexById(vertex.id(), graph, g) : (Vertex)g.V(new Object[0]).has(vertex.label(), this.bulkLoaderVertexId, vertex.id().toString()).next();
    }

    @Override
    public boolean useUserSuppliedIds() {
        return this.userSuppliedIds;
    }

    @Override
    public boolean keepOriginalIds() {
        return this.keepOriginalIds;
    }

    @Override
    public String getVertexIdProperty() {
        return this.bulkLoaderVertexId;
    }

    @Override
    public void configure(Configuration configuration) {
        if (configuration.containsKey(BulkLoaderVertexProgram.BULK_LOADER_VERTEX_ID_CFG_KEY)) {
            this.bulkLoaderVertexId = configuration.getString(BulkLoaderVertexProgram.BULK_LOADER_VERTEX_ID_CFG_KEY);
        }
        if (configuration.containsKey(BulkLoaderVertexProgram.USER_SUPPLIED_IDS_CFG_KEY)) {
            this.userSuppliedIds = configuration.getBoolean(BulkLoaderVertexProgram.USER_SUPPLIED_IDS_CFG_KEY);
        }
        if (configuration.containsKey(BulkLoaderVertexProgram.KEEP_ORIGINAL_IDS_CFG_KEY)) {
            this.keepOriginalIds = configuration.getBoolean(BulkLoaderVertexProgram.KEEP_ORIGINAL_IDS_CFG_KEY);
        }
    }

    private static /* synthetic */ void lambda$getOrCreateVertexProperty$1(VertexProperty vp, Property metaProperty) {
        Property existing2 = vp.property(metaProperty.key());
        if (!existing2.isPresent() || !existing2.value().equals(metaProperty.value())) {
            vp.property(metaProperty.key(), metaProperty.value());
        }
    }
}

