/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedPath;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdKeySerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;
import org.javatuples.Pair;

class GraphSONSerializersV3d0 {
    private GraphSONSerializersV3d0() {
    }

    static class DoubleJackonsDeserializer
    extends StdDeserializer<Double> {
        protected DoubleJackonsDeserializer() {
            super(Double.class);
        }

        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return jsonParser.getDoubleValue();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class IntegerJackonsDeserializer
    extends StdDeserializer<Integer> {
        protected IntegerJackonsDeserializer() {
            super(Integer.class);
        }

        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return jsonParser.getIntValue();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class TreeJacksonDeserializer
    extends StdDeserializer<Tree> {
        public TreeJacksonDeserializer() {
            super(Tree.class);
        }

        public Tree deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            List data = (List)deserializationContext.readValue(jsonParser, List.class);
            Tree t = new Tree();
            for (Map entry : data) {
                t.put(entry.get("key"), entry.get("value"));
            }
            return t;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class TraversalMetricsJacksonDeserializer
    extends StdDeserializer<TraversalMetrics> {
        public TraversalMetricsJacksonDeserializer() {
            super(TraversalMetrics.class);
        }

        public TraversalMetrics deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Map traversalMetricsData = (Map)deserializationContext.readValue(jsonParser, Map.class);
            return new DefaultTraversalMetrics(Math.round((Double)traversalMetricsData.get("dur") * 1000000.0), (List)traversalMetricsData.get("metrics"));
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class MetricsJacksonDeserializer
    extends StdDeserializer<Metrics> {
        public MetricsJacksonDeserializer() {
            super(Metrics.class);
        }

        public Metrics deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Map metricsData = (Map)deserializationContext.readValue(jsonParser, Map.class);
            MutableMetrics m = new MutableMetrics((String)metricsData.get("id"), (String)metricsData.get("name"));
            m.setDuration(Math.round((Double)metricsData.get("dur") * 1000000.0), TimeUnit.NANOSECONDS);
            for (Map.Entry count : ((Map)metricsData.getOrDefault("counts", new LinkedHashMap(0))).entrySet()) {
                m.setCount((String)count.getKey(), (Long)count.getValue());
            }
            for (Map.Entry count : ((Map)metricsData.getOrDefault("annotations", new LinkedHashMap(0))).entrySet()) {
                m.setAnnotation((String)count.getKey(), count.getValue());
            }
            for (MutableMetrics nested : (List)metricsData.getOrDefault("metrics", new ArrayList(0))) {
                m.addNested(nested);
            }
            return m;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class VertexPropertyJacksonDeserializer
    extends StdDeserializer<VertexProperty> {
        private static final JavaType propertiesType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);

        protected VertexPropertyJacksonDeserializer() {
            super(VertexProperty.class);
        }

        public VertexProperty deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedVertexProperty.Builder vp = DetachedVertexProperty.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    vp.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    vp.setLabel(jsonParser.getText());
                    continue;
                }
                if (jsonParser.getCurrentName().equals("value")) {
                    jsonParser.nextToken();
                    vp.setValue(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String key = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    Object val = deserializationContext.readValue(jsonParser, Object.class);
                    vp.addProperty(new DetachedProperty<Object>(key, val));
                }
            }
            return vp.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class PathJacksonDeserializer
    extends StdDeserializer<Path> {
        private static final JavaType setType = TypeFactory.defaultInstance().constructCollectionType(HashSet.class, String.class);

        public PathJacksonDeserializer() {
            super(Path.class);
        }

        public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Path p = MutablePath.make();
            List labels = new ArrayList();
            List objects = new ArrayList();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("labels")) {
                    jsonParser.nextToken();
                    labels = (List)deserializationContext.readValue(jsonParser, List.class);
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("objects")) continue;
                jsonParser.nextToken();
                objects = (List)deserializationContext.readValue(jsonParser, List.class);
            }
            for (int i = 0; i < objects.size(); ++i) {
                p.extend(objects.get(i), (Set)labels.get(i));
            }
            return p;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class PropertyJacksonDeserializer
    extends StdDeserializer<Property> {
        public PropertyJacksonDeserializer() {
            super(Property.class);
        }

        public Property deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String key = null;
            Object value = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("key")) {
                    jsonParser.nextToken();
                    key = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new DetachedProperty<Object>(key, value);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class EdgeJacksonDeserializer
    extends StdDeserializer<Edge> {
        public EdgeJacksonDeserializer() {
            super(Edge.class);
        }

        public Edge deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedEdge.Builder e = DetachedEdge.build();
            DetachedVertex.Builder inV = DetachedVertex.build();
            DetachedVertex.Builder outV = DetachedVertex.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    e.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    e.setLabel(jsonParser.getText());
                    continue;
                }
                if (jsonParser.getCurrentName().equals("outV")) {
                    jsonParser.nextToken();
                    outV.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("outVLabel")) {
                    jsonParser.nextToken();
                    outV.setLabel(jsonParser.getText());
                    continue;
                }
                if (jsonParser.getCurrentName().equals("inV")) {
                    jsonParser.nextToken();
                    inV.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("inVLabel")) {
                    jsonParser.nextToken();
                    inV.setLabel(jsonParser.getText());
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    e.addProperty((Property)deserializationContext.readValue(jsonParser, Property.class));
                }
            }
            e.setInV(inV.create());
            e.setOutV(outV.create());
            return e.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class VertexJacksonDeserializer
    extends StdDeserializer<Vertex> {
        public VertexJacksonDeserializer() {
            super(Vertex.class);
        }

        public Vertex deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedVertex.Builder v = DetachedVertex.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    v.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    v.setLabel(jsonParser.getText());
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        v.addProperty((DetachedVertexProperty)deserializationContext.readValue(jsonParser, VertexProperty.class));
                    }
                }
            }
            return v.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class GraphSONKeySerializer
    extends StdKeySerializer {
        GraphSONKeySerializer() {
        }

        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        public void serializeWithType(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        private void ser(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (Element.class.isAssignableFrom(o.getClass())) {
                jsonGenerator.writeFieldName(((Element)o).id().toString());
            } else {
                super.serialize(o, jsonGenerator, serializerProvider);
            }
        }
    }

    static final class MetricsJacksonSerializer
    extends StdScalarSerializer<Metrics> {
        public MetricsJacksonSerializer() {
            super(Metrics.class);
        }

        public void serialize(Metrics metrics, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id", metrics.getId());
            m.put("name", metrics.getName());
            m.put("counts", metrics.getCounts());
            m.put("dur", (double)metrics.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            if (!metrics.getAnnotations().isEmpty()) {
                m.put("annotations", metrics.getAnnotations());
            }
            if (!metrics.getNested().isEmpty()) {
                ArrayList nested = new ArrayList();
                metrics.getNested().forEach(it -> nested.add(it));
                m.put("metrics", nested);
            }
            jsonGenerator.writeObject(m);
        }
    }

    static final class TraversalMetricsJacksonSerializer
    extends StdScalarSerializer<TraversalMetrics> {
        public TraversalMetricsJacksonSerializer() {
            super(TraversalMetrics.class);
        }

        public void serialize(TraversalMetrics traversalMetrics, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.put("dur", Double.valueOf((double)traversalMetrics.getDuration(TimeUnit.NANOSECONDS) / 1000000.0));
            ArrayList<? extends Metrics> metrics = new ArrayList<Metrics>();
            metrics.addAll(traversalMetrics.getMetrics());
            m.put("metrics", metrics);
            jsonGenerator.writeObject(m);
        }
    }

    static final class DoubleGraphSONSerializer
    extends StdScalarSerializer<Double> {
        public DoubleGraphSONSerializer() {
            super(Double.class);
        }

        public void serialize(Double doubleValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(doubleValue.doubleValue());
        }
    }

    static final class IntegerGraphSONSerializer
    extends StdScalarSerializer<Integer> {
        public IntegerGraphSONSerializer() {
            super(Integer.class);
        }

        public void serialize(Integer integer, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(integer.intValue());
        }
    }

    static final class TraversalExplanationJacksonSerializer
    extends StdSerializer<TraversalExplanation> {
        public TraversalExplanationJacksonSerializer() {
            super(TraversalExplanation.class);
        }

        public void serialize(TraversalExplanation traversalExplanation, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            m.put("original", this.getStepsAsList(traversalExplanation.getOriginalTraversal()));
            List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = traversalExplanation.getStrategyTraversals();
            ArrayList intermediates = new ArrayList();
            for (Pair<TraversalStrategy, Traversal.Admin<?, ?>> pair : strategyTraversals) {
                HashMap<String, Object> intermediate = new HashMap<String, Object>();
                intermediate.put("strategy", ((TraversalStrategy)pair.getValue0()).toString());
                intermediate.put("category", ((TraversalStrategy)pair.getValue0()).getTraversalCategory().getSimpleName());
                intermediate.put("traversal", this.getStepsAsList((Traversal.Admin)pair.getValue1()));
                intermediates.add(intermediate);
            }
            m.put("intermediate", intermediates);
            if (strategyTraversals.isEmpty()) {
                m.put("final", this.getStepsAsList(traversalExplanation.getOriginalTraversal()));
            } else {
                m.put("final", this.getStepsAsList((Traversal.Admin)strategyTraversals.get(strategyTraversals.size() - 1).getValue1()));
            }
            jsonGenerator.writeObject(m);
        }

        private List<String> getStepsAsList(Traversal.Admin<?, ?> t) {
            ArrayList<String> steps = new ArrayList<String>();
            t.getSteps().iterator().forEachRemaining(s -> steps.add(s.toString()));
            return steps;
        }
    }

    static final class TreeJacksonSerializer
    extends StdScalarSerializer<Tree> {
        public TreeJacksonSerializer() {
            super(Tree.class);
        }

        public void serialize(Tree tree, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeStartArray();
            Set set = tree.entrySet();
            for (Map.Entry entry : set) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("key", entry.getKey());
                jsonGenerator.writeObjectField("value", entry.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }

    static final class PathJacksonSerializer
    extends StdScalarSerializer<Path> {
        public PathJacksonSerializer() {
            super(Path.class);
        }

        public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeStartObject();
            DetachedPath p = DetachedFactory.detach(path, false);
            jsonGenerator.writeObjectField("labels", p.labels());
            jsonGenerator.writeObjectField("objects", p.objects());
            jsonGenerator.writeEndObject();
        }
    }

    static final class VertexPropertyJacksonSerializer
    extends StdScalarSerializer<VertexProperty> {
        private final boolean normalize;
        private final boolean includeLabel;

        public VertexPropertyJacksonSerializer(boolean normalize, boolean includeLabel) {
            super(VertexProperty.class);
            this.normalize = normalize;
            this.includeLabel = includeLabel;
        }

        public void serialize(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", property.id());
            jsonGenerator.writeObjectField("value", property.value());
            if (this.includeLabel) {
                jsonGenerator.writeStringField("label", property.label());
            }
            VertexPropertyJacksonSerializer.tryWriteMetaProperties(property, jsonGenerator, this.normalize);
            jsonGenerator.writeEndObject();
        }

        private static void tryWriteMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, boolean normalize) throws IOException {
            if (property instanceof DetachedVertexProperty) {
                if (property.properties(new String[0]).hasNext()) {
                    VertexPropertyJacksonSerializer.writeMetaProperties(property, jsonGenerator, normalize);
                }
            } else if (property.graph().features().vertex().supportsMetaProperties() && property.properties(new String[0]).hasNext()) {
                VertexPropertyJacksonSerializer.writeMetaProperties(property, jsonGenerator, normalize);
            }
        }

        private static void writeMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, boolean normalize) throws IOException {
            Iterator metaProperties;
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeStartObject();
            Iterator iterator = metaProperties = normalize ? IteratorUtils.list(property.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : property.properties(new String[0]);
            while (metaProperties.hasNext()) {
                Property metaProperty = metaProperties.next();
                jsonGenerator.writeObjectField(metaProperty.key(), metaProperty.value());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class PropertyJacksonSerializer
    extends StdScalarSerializer<Property> {
        public PropertyJacksonSerializer() {
            super(Property.class);
        }

        public void serialize(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("key", (Object)property.key());
            jsonGenerator.writeObjectField("value", property.value());
            jsonGenerator.writeEndObject();
        }
    }

    static final class EdgeJacksonSerializer
    extends StdScalarSerializer<Edge> {
        private final boolean normalize;

        public EdgeJacksonSerializer(boolean normalize) {
            super(Edge.class);
            this.normalize = normalize;
        }

        public void serialize(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", edge.id());
            jsonGenerator.writeStringField("label", edge.label());
            jsonGenerator.writeStringField("inVLabel", edge.inVertex().label());
            jsonGenerator.writeStringField("outVLabel", edge.outVertex().label());
            jsonGenerator.writeObjectField("inV", edge.inVertex().id());
            jsonGenerator.writeObjectField("outV", edge.outVertex().id());
            this.writeProperties(edge, jsonGenerator);
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Edge edge, JsonGenerator jsonGenerator) throws IOException {
            Iterator elementProperties;
            Iterator iterator = elementProperties = this.normalize ? IteratorUtils.list(edge.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : edge.properties(new String[0]);
            if (elementProperties.hasNext()) {
                jsonGenerator.writeFieldName("properties");
                jsonGenerator.writeStartObject();
                elementProperties.forEachRemaining(prop -> GraphSONUtil.safeWriteObjectField(jsonGenerator, prop.key(), prop));
                jsonGenerator.writeEndObject();
            }
        }
    }

    static final class VertexJacksonSerializer
    extends StdScalarSerializer<Vertex> {
        private final boolean normalize;

        public VertexJacksonSerializer(boolean normalize) {
            super(Vertex.class);
            this.normalize = normalize;
        }

        public void serialize(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", vertex.id());
            jsonGenerator.writeStringField("label", vertex.label());
            this.writeProperties(vertex, jsonGenerator);
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Vertex vertex, JsonGenerator jsonGenerator) throws IOException {
            if (vertex.keys().size() == 0) {
                return;
            }
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeStartObject();
            List<String> keys = this.normalize ? IteratorUtils.list(vertex.keys().iterator(), Comparator.naturalOrder()) : new ArrayList<String>(vertex.keys());
            for (String key : keys) {
                Iterator vertexProperties = this.normalize ? IteratorUtils.list(vertex.properties(key), Comparators.PROPERTY_COMPARATOR).iterator() : vertex.properties(key);
                if (!vertexProperties.hasNext()) continue;
                jsonGenerator.writeFieldName(key);
                jsonGenerator.writeStartArray();
                while (vertexProperties.hasNext()) {
                    jsonGenerator.writeObject(vertexProperties.next());
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }
}

