/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializersV1d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializersV2d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.ToStringGraphSONSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationConfig;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.ser.DefaultSerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.ser.SerializerFactory;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.ToStringSerializer;

final class GraphSONSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 1L;
    private final JsonSerializer<Object> unknownTypeSerializer;

    public GraphSONSerializerProvider(GraphSONVersion version) {
        if (version == GraphSONVersion.V1_0) {
            this.setDefaultKeySerializer((JsonSerializer)new GraphSONSerializersV1d0.GraphSONKeySerializer());
            this.unknownTypeSerializer = new ToStringSerializer();
        } else if (version == GraphSONVersion.V2_0) {
            this.setDefaultKeySerializer((JsonSerializer)new GraphSONSerializersV2d0.GraphSONKeySerializer());
            this.unknownTypeSerializer = new ToStringGraphSONSerializer();
        } else {
            this.unknownTypeSerializer = new ToStringGraphSONSerializer();
        }
    }

    protected GraphSONSerializerProvider(SerializerProvider src, SerializationConfig config, SerializerFactory f, JsonSerializer<Object> unknownTypeSerializer) {
        super(src, config, f);
        this.unknownTypeSerializer = unknownTypeSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> aClass) {
        return this.unknownTypeSerializer;
    }

    public GraphSONSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new GraphSONSerializerProvider((SerializerProvider)this, config, jsf, this.unknownTypeSerializer);
    }
}

