/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.flat;

import groovyx.gprof.CallInfo;
import groovyx.gprof.CallTree;
import groovyx.gprof.MethodCallInfo;
import groovyx.gprof.MethodInfo;
import groovyx.gprof.ReportNormalizer;
import groovyx.gprof.ThreadRunInfo;
import groovyx.gprof.flat.FlatReportMethodElement;
import groovyx.gprof.flat.FlatReportThreadElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatReportNormalizer
implements ReportNormalizer {
    private boolean separateThread = false;

    public void setSeparateThread(boolean separateThread) {
        this.separateThread = separateThread;
    }

    public List<FlatReportThreadElement> normalize(final CallTree callTree) {
        final ArrayList<FlatReportThreadElement> elements = new ArrayList<FlatReportThreadElement>();
        callTree.visit(new CallTree.NodeVisitor(){
            Stack<Map<MethodInfo, FlatReportMethodElement>> methodElementMapStack = new Stack();

            public void exit(CallTree.Node node) {
                CallInfo call = node.getData();
                if (call instanceof ThreadRunInfo) {
                    ThreadRunInfo threadRun = (ThreadRunInfo)call;
                    if (FlatReportNormalizer.this.separateThread || threadRun.equals(callTree.getRoot().getData())) {
                        Map<MethodInfo, FlatReportMethodElement> methodElementMap = this.methodElementMapStack.pop();
                        ArrayList<FlatReportMethodElement> methodElements = new ArrayList<FlatReportMethodElement>(methodElementMap.values());
                        Collections.sort(methodElements, new MethodElementComparator());
                        FlatReportThreadElement threadElement = new FlatReportThreadElement(threadRun.getThread());
                        long totalTime = 0L;
                        for (FlatReportMethodElement methodElement : methodElements) {
                            totalTime += methodElement.getSelfTime();
                        }
                        long cumulativeTime = 0L;
                        for (FlatReportMethodElement methodElement : methodElements) {
                            methodElement.setTimePercent((float)methodElement.getSelfTime() / (float)totalTime * 100.0f);
                            methodElement.setCumulativeTime(cumulativeTime += methodElement.getSelfTime());
                            threadElement.addMethodElement(methodElement);
                        }
                        elements.add(threadElement);
                    }
                }
            }

            public void visit(CallTree.Node node) {
                CallInfo call = node.getData();
                if (call instanceof ThreadRunInfo) {
                    ThreadRunInfo threadRun = (ThreadRunInfo)call;
                    if (FlatReportNormalizer.this.separateThread || threadRun.equals(callTree.getRoot().getData())) {
                        this.methodElementMapStack.push(new HashMap());
                    }
                } else if (call instanceof MethodCallInfo) {
                    boolean recursive;
                    final MethodCallInfo methodCall = (MethodCallInfo)call;
                    Map<MethodInfo, FlatReportMethodElement> methodElementMap = this.methodElementMapStack.peek();
                    FlatReportMethodElement element = methodElementMap.get(methodCall.getMethod());
                    if (element == null) {
                        element = new FlatReportMethodElement(methodCall.getMethod());
                        methodElementMap.put(methodCall.getMethod(), element);
                    }
                    boolean bl = recursive = node.getParent().getData() instanceof MethodCallInfo && ((MethodCallInfo)node.getParent().getData()).getMethod().equals(methodCall.getMethod());
                    if (!recursive) {
                        element.setCalls(element.getCalls() + 1L);
                        final long[] recursiveTime = new long[]{0L};
                        node.visit(new CallTree.NodeVisitor(){

                            public void visit(CallTree.Node child) {
                                MethodCallInfo childMethodCall = (MethodCallInfo)child.getData();
                                if (childMethodCall.getMethod().equals(methodCall.getMethod())) {
                                    recursiveTime[0] = recursiveTime[0] + childMethodCall.getSelfTime();
                                }
                            }
                        });
                        long selfTime = methodCall.getSelfTime() + recursiveTime[0];
                        element.setSelfTime(element.getSelfTime() + selfTime);
                        element.setMaxSelfTime(Math.max(element.getMaxSelfTime(), selfTime));
                        element.setMinSelfTime(element.getMinSelfTime() == 0L ? selfTime : Math.min(element.getMinSelfTime(), selfTime));
                        long totalTime = methodCall.getTime();
                        element.setTime(element.getTime() + totalTime);
                        element.setMaxTime(Math.max(element.getMaxTime(), totalTime));
                        element.setMinTime(element.getMinTime() == 0L ? methodCall.getTime() : Math.min(element.getMinTime(), totalTime));
                    }
                }
            }
        });
        Collections.sort(elements, new ThreadElementComparator());
        return elements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodElementComparator
    implements Comparator<FlatReportMethodElement> {
        MethodElementComparator() {
        }

        @Override
        public int compare(FlatReportMethodElement o1, FlatReportMethodElement o2) {
            int r = -Long.compare(o1.getSelfTime(), o2.getSelfTime());
            if (r == 0 && (r = -Long.valueOf(o1.getCalls()).compareTo(o2.getCalls())) == 0) {
                r = o1.getMethod().getName().compareTo(o2.getMethod().getName());
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadElementComparator
    implements Comparator<FlatReportThreadElement> {
        ThreadElementComparator() {
        }

        @Override
        public int compare(FlatReportThreadElement o1, FlatReportThreadElement o2) {
            return Long.compare(o1.getThread().getThreadId(), o2.getThread().getThreadId());
        }
    }
}

