/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.flat;

import groovyx.gprof.MethodInfo;
import groovyx.gprof.ReportElement;

public class FlatReportMethodElement
implements ReportElement {
    private MethodInfo method;
    private long calls;
    private float timePercent;
    private long cumulativeTime;
    private long time;
    private long maxTime;
    private long minTime;
    private long selfTime;
    private long maxSelfTime;
    private long minSelfTime;

    public FlatReportMethodElement(MethodInfo method) {
        this.method = method;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public long getCalls() {
        return this.calls;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    public float getTimePerCall() {
        return this.time / this.calls;
    }

    public long getCumulativeTime() {
        return this.cumulativeTime;
    }

    public void setCumulativeTime(long cumulativeTime) {
        this.cumulativeTime = cumulativeTime;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public float getSelfTimePerCall() {
        return this.selfTime / this.calls;
    }

    public long getSelfTime() {
        return this.selfTime;
    }

    public void setSelfTime(long selfTime) {
        this.selfTime = selfTime;
    }

    public long getMaxSelfTime() {
        return this.maxSelfTime;
    }

    public void setMaxSelfTime(long maxSelfTime) {
        this.maxSelfTime = maxSelfTime;
    }

    public long getMinSelfTime() {
        return this.minSelfTime;
    }

    public void setMinSelfTime(long minSelfTime) {
        this.minSelfTime = minSelfTime;
    }

    public float getTimePercent() {
        return this.timePercent;
    }

    public void setTimePercent(float timePercent) {
        this.timePercent = timePercent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatReportMethodElement that = (FlatReportMethodElement)o;
        if (this.calls != that.calls) {
            return false;
        }
        if (this.cumulativeTime != that.cumulativeTime) {
            return false;
        }
        if (this.maxSelfTime != that.maxSelfTime) {
            return false;
        }
        if (this.maxTime != that.maxTime) {
            return false;
        }
        if (this.minSelfTime != that.minSelfTime) {
            return false;
        }
        if (this.minTime != that.minTime) {
            return false;
        }
        if (this.selfTime != that.selfTime) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (Float.compare(that.timePercent, this.timePercent) != 0) {
            return false;
        }
        return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (int)(this.calls ^ this.calls >>> 32);
        result = 31 * result + (this.timePercent != 0.0f ? Float.floatToIntBits(this.timePercent) : 0);
        result = 31 * result + (int)(this.cumulativeTime ^ this.cumulativeTime >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.maxTime ^ this.maxTime >>> 32);
        result = 31 * result + (int)(this.minTime ^ this.minTime >>> 32);
        result = 31 * result + (int)(this.selfTime ^ this.selfTime >>> 32);
        result = 31 * result + (int)(this.maxSelfTime ^ this.maxSelfTime >>> 32);
        result = 31 * result + (int)(this.minSelfTime ^ this.minSelfTime >>> 32);
        return result;
    }

    public String toString() {
        return "FlatReportMethodElement{method=" + this.method + ", calls=" + this.calls + ", timePercent=" + this.timePercent + ", cumulativeTime=" + this.cumulativeTime + ", time=" + this.time + ", maxTime=" + this.maxTime + ", minTime=" + this.minTime + ", selfTime=" + this.selfTime + ", maxSelfTime=" + this.maxSelfTime + ", minSelfTime=" + this.minSelfTime + '}';
    }
}

