/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof;

import groovyx.gprof.CallMatcher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallFilter {
    private List<CallMatcher> includes = new ArrayList<CallMatcher>();
    private List<CallMatcher> excludes = new ArrayList<CallMatcher>();

    public void addInclude(String pattern) {
        this.includes.add(new CallMatcher(pattern));
    }

    public void addIncludes(List<String> patterns) {
        for (String pattern : patterns) {
            this.addInclude(pattern);
        }
    }

    public void addExclude(String pattern) {
        this.excludes.add(new CallMatcher(pattern));
    }

    public void addExcludes(List<String> patterns) {
        for (String pattern : patterns) {
            this.addExclude(pattern);
        }
    }

    public boolean accept(String text) {
        if (!this.includes.isEmpty()) {
            boolean included = false;
            for (CallMatcher include : this.includes) {
                if (!include.match(text)) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
        }
        if (!this.excludes.isEmpty()) {
            boolean excluded = false;
            for (CallMatcher exclude : this.excludes) {
                if (!exclude.match(text)) continue;
                excluded = true;
                break;
            }
            if (excluded) {
                return false;
            }
        }
        return true;
    }
}

