'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScenarioDescription = getScenarioDescription;
exports.getStepKeyword = getStepKeyword;
exports.getStepLineToPickledStepMap = getStepLineToPickledStepMap;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getScenarioDescription(_ref) {
  var pickle = _ref.pickle,
      scenarioLineToDescriptionMap = _ref.scenarioLineToDescriptionMap;

  return _lodash2.default.chain(pickle.locations).map(function (_ref2) {
    var line = _ref2.line;
    return scenarioLineToDescriptionMap[line];
  }).compact().first().value();
}

function getStepKeyword(_ref3) {
  var pickleStep = _ref3.pickleStep,
      stepLineToKeywordMap = _ref3.stepLineToKeywordMap;

  return _lodash2.default.chain(pickleStep.locations).map(function (_ref4) {
    var line = _ref4.line;
    return stepLineToKeywordMap[line];
  }).compact().first().value();
}

function getStepLineToPickledStepMap(pickle) {
  return _lodash2.default.chain(pickle.steps).map(function (step) {
    return [_lodash2.default.last(step.locations).line, step];
  }).fromPairs().value();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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