'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepLineToKeywordMap = getStepLineToKeywordMap;
exports.getScenarioLineToDescriptionMap = getScenarioLineToDescriptionMap;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getStepLineToKeywordMap(gherkinDocument) {
  return _lodash2.default.chain(gherkinDocument.feature.children).map('steps').flatten().map(function (step) {
    return [step.location.line, step.keyword];
  }).fromPairs().value();
}

function getScenarioLineToDescriptionMap(gherkinDocument) {
  return _lodash2.default.chain(gherkinDocument.feature.children).map(function (element) {
    return [element.location.line, element.description];
  }).fromPairs().value();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9mb3JtYXR0ZXIvaGVscGVycy9naGVya2luX2RvY3VtZW50X3BhcnNlci5qcyJdLCJuYW1lcyI6WyJnZXRTdGVwTGluZVRvS2V5d29yZE1hcCIsImdldFNjZW5hcmlvTGluZVRvRGVzY3JpcHRpb25NYXAiLCJnaGVya2luRG9jdW1lbnQiLCJjaGFpbiIsImZlYXR1cmUiLCJjaGlsZHJlbiIsIm1hcCIsImZsYXR0ZW4iLCJzdGVwIiwibG9jYXRpb24iLCJsaW5lIiwia2V5d29yZCIsImZyb21QYWlycyIsInZhbHVlIiwiZWxlbWVudCIsImRlc2NyaXB0aW9uIl0sIm1hcHBpbmdzIjoiOzs7OztRQUVnQkEsdUIsR0FBQUEsdUI7UUFTQUMsK0IsR0FBQUEsK0I7O0FBWGhCOzs7Ozs7QUFFTyxTQUFTRCx1QkFBVCxDQUFpQ0UsZUFBakMsRUFBa0Q7QUFDdkQsU0FBTyxpQkFBRUMsS0FBRixDQUFRRCxnQkFBZ0JFLE9BQWhCLENBQXdCQyxRQUFoQyxFQUNKQyxHQURJLENBQ0EsT0FEQSxFQUVKQyxPQUZJLEdBR0pELEdBSEksQ0FHQTtBQUFBLFdBQVEsQ0FBQ0UsS0FBS0MsUUFBTCxDQUFjQyxJQUFmLEVBQXFCRixLQUFLRyxPQUExQixDQUFSO0FBQUEsR0FIQSxFQUlKQyxTQUpJLEdBS0pDLEtBTEksRUFBUDtBQU1EOztBQUVNLFNBQVNaLCtCQUFULENBQXlDQyxlQUF6QyxFQUEwRDtBQUMvRCxTQUFPLGlCQUFFQyxLQUFGLENBQVFELGdCQUFnQkUsT0FBaEIsQ0FBd0JDLFFBQWhDLEVBQ0pDLEdBREksQ0FDQTtBQUFBLFdBQVcsQ0FBQ1EsUUFBUUwsUUFBUixDQUFpQkMsSUFBbEIsRUFBd0JJLFFBQVFDLFdBQWhDLENBQVg7QUFBQSxHQURBLEVBRUpILFNBRkksR0FHSkMsS0FISSxFQUFQO0FBSUQiLCJmaWxlIjoiZ2hlcmtpbl9kb2N1bWVudF9wYXJzZXIuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgXyBmcm9tICdsb2Rhc2gnXG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRTdGVwTGluZVRvS2V5d29yZE1hcChnaGVya2luRG9jdW1lbnQpIHtcbiAgcmV0dXJuIF8uY2hhaW4oZ2hlcmtpbkRvY3VtZW50LmZlYXR1cmUuY2hpbGRyZW4pXG4gICAgLm1hcCgnc3RlcHMnKVxuICAgIC5mbGF0dGVuKClcbiAgICAubWFwKHN0ZXAgPT4gW3N0ZXAubG9jYXRpb24ubGluZSwgc3RlcC5rZXl3b3JkXSlcbiAgICAuZnJvbVBhaXJzKClcbiAgICAudmFsdWUoKVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0U2NlbmFyaW9MaW5lVG9EZXNjcmlwdGlvbk1hcChnaGVya2luRG9jdW1lbnQpIHtcbiAgcmV0dXJuIF8uY2hhaW4oZ2hlcmtpbkRvY3VtZW50LmZlYXR1cmUuY2hpbGRyZW4pXG4gICAgLm1hcChlbGVtZW50ID0+IFtlbGVtZW50LmxvY2F0aW9uLmxpbmUsIGVsZW1lbnQuZGVzY3JpcHRpb25dKVxuICAgIC5mcm9tUGFpcnMoKVxuICAgIC52YWx1ZSgpXG59XG4iXX0=