/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.util.function.HashSetSupplier;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.javatuples.Pair;

final class UtilSerializers {
    private UtilSerializers() {
    }

    static final class EntrySerializer
    extends Serializer<Map.Entry> {
        EntrySerializer() {
        }

        public void write(Kryo kryo, Output output, Map.Entry entry) {
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }

        public Map.Entry read(Kryo kryo, Input input, Class<Map.Entry> entryClass) {
            return new AbstractMap.SimpleEntry<Object, Object>(kryo.readClassAndObject(input), kryo.readClassAndObject(input));
        }
    }

    static final class PairSerializer
    implements SerializerShim<Pair> {
        PairSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Pair pair) {
            kryo.writeClassAndObject(output, pair.getValue0());
            kryo.writeClassAndObject(output, pair.getValue1());
        }

        @Override
        public <I extends InputShim> Pair read(KryoShim<I, ?> kryo, I input, Class<Pair> pairClass) {
            return Pair.with((Object)kryo.readClassAndObject(input), (Object)kryo.readClassAndObject(input));
        }
    }

    static final class URISerializer
    implements SerializerShim<URI> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, URI uri) {
            output.writeString(uri.toString());
        }

        @Override
        public <I extends InputShim> URI read(KryoShim<I, ?> kryo, I input, Class<URI> uriClass) {
            return URI.create(input.readString());
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    }

    static final class UUIDSerializer
    implements SerializerShim<UUID> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, UUID uuid) {
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
        }

        @Override
        public <I extends InputShim> UUID read(KryoShim<I, ?> kryo, I input, Class<UUID> uuidClass) {
            return new UUID(input.readLong(), input.readLong());
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    }

    public static final class HashSetSupplierSerializer
    implements SerializerShim<HashSetSupplier> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, HashSetSupplier hashSetSupplier) {
        }

        @Override
        public <I extends InputShim> HashSetSupplier read(KryoShim<I, ?> kryo, I input, Class<HashSetSupplier> clazz) {
            return HashSetSupplier.instance();
        }
    }

    public static final class InetAddressSerializer
    implements SerializerShim<InetAddress> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, InetAddress addy) {
            String str = addy.toString().trim();
            int slash = str.indexOf(47);
            if (slash >= 0) {
                if (slash == 0) {
                    output.writeString(str.substring(1));
                } else {
                    output.writeString(str.substring(0, slash));
                }
            }
        }

        @Override
        public <I extends InputShim> InetAddress read(KryoShim<I, ?> kryo, I input, Class<InetAddress> clazz) {
            try {
                return InetAddress.getByName(input.readString());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class ClassArraySerializer
    implements SerializerShim<Class[]> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Class[] object) {
            output.writeInt(object.length);
            for (Class clazz : object) {
                output.writeString(clazz.getName());
            }
        }

        @Override
        public <I extends InputShim> Class[] read(KryoShim<I, ?> kryo, I input, Class<Class[]> clazz) {
            int size = input.readInt();
            Class[] clazzes = new Class[size];
            for (int i = 0; i < size; ++i) {
                try {
                    clazzes[i] = Class.forName(input.readString());
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return clazzes;
        }
    }

    public static final class ClassSerializer
    implements SerializerShim<Class> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Class object) {
            output.writeString(object.getName());
        }

        @Override
        public <I extends InputShim> Class read(KryoShim<I, ?> kryo, I input, Class<Class> clazz) {
            String name = input.readString();
            try {
                return Class.forName(name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class ByteBufferSerializer
    implements SerializerShim<ByteBuffer> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ByteBuffer bb) {
            byte[] b = bb.array();
            int arrayOffset = bb.arrayOffset();
            Arrays.copyOfRange(b, arrayOffset + bb.position(), arrayOffset + bb.limit());
            output.writeInt(b.length);
            output.writeBytes(b, 0, b.length);
        }

        @Override
        public <I extends InputShim> ByteBuffer read(KryoShim<I, ?> kryo, I input, Class<ByteBuffer> clazz) {
            int len = input.readInt();
            byte[] b = input.readBytes(len);
            ByteBuffer bb = ByteBuffer.allocate(len);
            bb.put(b);
            return bb;
        }
    }

    public static final class ArraysAsListSerializer
    implements SerializerShim<List> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, List list) {
            ArrayList l = new ArrayList(list);
            kryo.writeObject(output, l);
        }

        @Override
        public <I extends InputShim> List read(KryoShim<I, ?> kryo, I input, Class<List> clazz) {
            return kryo.readObject(input, ArrayList.class);
        }
    }
}

