/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.shaded.kryo.Kryo;

public final class GryoPool {
    public static final String CONFIG_IO_REGISTRY = "gremlin.io.registry";
    public static final String CONFIG_IO_GRYO_POOL_SIZE = "gremlin.io.gryo.poolSize";
    public static final int CONFIG_IO_GRYO_POOL_SIZE_DEFAULT = 256;
    private Queue<GryoReader> gryoReaders;
    private Queue<GryoWriter> gryoWriters;
    private Queue<Kryo> kryos;
    private GryoMapper mapper;

    public static Builder build() {
        return new Builder();
    }

    private GryoPool() {
    }

    public GryoMapper getMapper() {
        return this.mapper;
    }

    public Kryo takeKryo() {
        Kryo kryo = this.kryos.poll();
        return null == kryo ? this.mapper.createMapper() : kryo;
    }

    public GryoReader takeReader() {
        GryoReader reader = this.gryoReaders.poll();
        return null == reader ? GryoReader.build().mapper(this.mapper).create() : reader;
    }

    public GryoWriter takeWriter() {
        GryoWriter writer = this.gryoWriters.poll();
        return null == writer ? GryoWriter.build().mapper(this.mapper).create() : writer;
    }

    public void offerKryo(Kryo kryo) {
        this.kryos.offer(kryo);
    }

    public void offerReader(GryoReader gryoReader) {
        this.gryoReaders.offer(gryoReader);
    }

    public void offerWriter(GryoWriter gryoWriter) {
        this.gryoWriters.offer(gryoWriter);
    }

    public <A> A readWithKryo(Function<Kryo, A> kryoFunction) {
        Kryo kryo = this.takeKryo();
        A a = kryoFunction.apply(kryo);
        this.offerKryo(kryo);
        return a;
    }

    public void writeWithKryo(Consumer<Kryo> kryoConsumer) {
        Kryo kryo = this.takeKryo();
        kryoConsumer.accept(kryo);
        this.offerKryo(kryo);
    }

    public <A> A doWithReader(Function<GryoReader, A> readerFunction) {
        GryoReader gryoReader = this.takeReader();
        A a = readerFunction.apply(gryoReader);
        this.offerReader(gryoReader);
        return a;
    }

    public void doWithWriter(Consumer<GryoWriter> writerFunction) {
        GryoWriter gryoWriter = this.takeWriter();
        writerFunction.accept(gryoWriter);
        this.offerWriter(gryoWriter);
    }

    private void createPool(int poolSize, Type type, GryoMapper gryoMapper) {
        int i;
        this.mapper = gryoMapper;
        if (type.equals((Object)Type.READER) || type.equals((Object)Type.READER_WRITER)) {
            this.gryoReaders = new LinkedBlockingQueue<GryoReader>(poolSize);
            for (i = 0; i < poolSize; ++i) {
                this.gryoReaders.add(GryoReader.build().mapper(gryoMapper).create());
            }
        }
        if (type.equals((Object)Type.WRITER) || type.equals((Object)Type.READER_WRITER)) {
            this.gryoWriters = new LinkedBlockingQueue<GryoWriter>(poolSize);
            for (i = 0; i < poolSize; ++i) {
                this.gryoWriters.add(GryoWriter.build().mapper(gryoMapper).create());
            }
        }
        this.kryos = new LinkedBlockingQueue<Kryo>(poolSize);
        for (i = 0; i < poolSize; ++i) {
            this.kryos.add(gryoMapper.createMapper());
        }
    }

    public static class Builder {
        private int poolSize = 256;
        private List<IoRegistry> ioRegistries = new ArrayList<IoRegistry>();
        private Type type = Type.READER_WRITER;
        private Consumer<GryoMapper.Builder> gryoMapperConsumer = null;

        public Builder ioRegistries(List<Object> ioRegistryClassNames) {
            this.ioRegistries.addAll(Builder.tryCreateIoRegistry(ioRegistryClassNames));
            return this;
        }

        public Builder ioRegistry(Object ioRegistryClassName) {
            this.ioRegistries.addAll(Builder.tryCreateIoRegistry(Collections.singletonList(ioRegistryClassName)));
            return this;
        }

        public Builder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder initializeMapper(Consumer<GryoMapper.Builder> gryoMapperConsumer) {
            this.gryoMapperConsumer = gryoMapperConsumer;
            return this;
        }

        public GryoPool create() {
            GryoMapper.Builder mapper = GryoMapper.build();
            GryoPool gryoPool = new GryoPool();
            if (null != this.ioRegistries) {
                this.ioRegistries.forEach(mapper::addRegistry);
            }
            if (null != this.gryoMapperConsumer) {
                this.gryoMapperConsumer.accept(mapper);
            }
            gryoPool.createPool(this.poolSize, this.type, mapper.create());
            return gryoPool;
        }

        private static List<IoRegistry> tryCreateIoRegistry(List<Object> classNames) {
            if (classNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IoRegistry> registries = new ArrayList<IoRegistry>();
            classNames.forEach(c -> {
                try {
                    String className = c.toString();
                    Class<?> clazz = Class.forName(className);
                    try {
                        Method instanceMethod = Builder.tryInstanceMethod(clazz);
                        if (!IoRegistry.class.isAssignableFrom(instanceMethod.getReturnType())) {
                            throw new Exception();
                        }
                        registries.add((IoRegistry)instanceMethod.invoke(null, new Object[0]));
                    }
                    catch (Exception methodex) {
                        registries.add((IoRegistry)clazz.newInstance());
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            });
            return registries;
        }

        private static Method tryInstanceMethod(Class clazz) {
            Method instanceMethod;
            try {
                instanceMethod = clazz.getDeclaredMethod("instance", new Class[0]);
            }
            catch (Exception methodex) {
                instanceMethod = null;
            }
            if (null == instanceMethod) {
                try {
                    instanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
                }
                catch (Exception methodex) {
                    instanceMethod = null;
                }
            }
            return instanceMethod;
        }
    }

    public static enum Type {
        READER,
        WRITER,
        READER_WRITER;

    }
}

