/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class OrP<V>
extends ConnectiveP<V> {
    public OrP(List<P<V>> predicates) {
        super(predicates);
        for (P<V> p : predicates) {
            this.or(p);
        }
        this.biPredicate = new OrBiPredicate(this);
    }

    @Deprecated
    public OrP(P<V> ... predicates) {
        this(Arrays.asList(predicates));
    }

    @Override
    public P<V> or(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be or'd together");
        }
        if (predicate instanceof OrP) {
            this.predicates.addAll(((OrP)predicate).getPredicates());
        } else {
            this.predicates.add((P)predicate);
        }
        return this;
    }

    @Override
    public P<V> negate() {
        super.negate();
        return new AndP(this.predicates);
    }

    @Override
    public String toString() {
        return "or(" + StringFactory.removeEndBrackets(this.predicates) + ")";
    }

    @Override
    public OrP<V> clone() {
        OrP clone = (OrP)super.clone();
        clone.biPredicate = new OrBiPredicate(clone);
        return clone;
    }

    private class OrBiPredicate
    implements BiPredicate<V, V>,
    Serializable {
        private final OrP<V> orP;

        private OrBiPredicate(OrP<V> orP2) {
            this.orP = orP2;
        }

        @Override
        public boolean test(V valueA, V valueB) {
            for (P predicate : this.orP.predicates) {
                if (!predicate.test(valueA)) continue;
                return true;
            }
            return false;
        }
    }
}

