/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.dsl.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PageRankVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PeerPressureVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ProgramVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ColumnTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.FunctionTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.LoopTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.PredicateTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TrueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.FromToModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TimesModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.ChooseStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.LambdaFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.PathFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.SampleGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TailGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TimeLimitStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CoalesceStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConstantStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DedupLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupCountStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStepV3d0;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaCollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LoopsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyKeyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SampleLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TailLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.UnfoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupCountSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupSideEffectStepV3d0;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.LambdaSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SackValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectCapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StoreStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SubgraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TraversalSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TreeSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.function.ConstantSupplier;

public interface GraphTraversal<S, E>
extends Traversal<S, E> {
    @Override
    default public Admin<S, E> asAdmin() {
        return (Admin)this;
    }

    default public <E2> GraphTraversal<S, E2> map(Function<Traverser<E>, E2> function) {
        this.asAdmin().getBytecode().addStep("map", function);
        return this.asAdmin().addStep(new LambdaMapStep<E, E2>(this.asAdmin(), function));
    }

    default public <E2> GraphTraversal<S, E2> map(Traversal<?, E2> mapTraversal) {
        this.asAdmin().getBytecode().addStep("map", mapTraversal);
        return this.asAdmin().addStep((Step)new TraversalMapStep(this.asAdmin(), mapTraversal));
    }

    default public <E2> GraphTraversal<S, E2> flatMap(Function<Traverser<E>, Iterator<E2>> function) {
        this.asAdmin().getBytecode().addStep("flatMap", function);
        return this.asAdmin().addStep((Step)new LambdaFlatMapStep(this.asAdmin(), function));
    }

    default public <E2> GraphTraversal<S, E2> flatMap(Traversal<?, E2> flatMapTraversal) {
        this.asAdmin().getBytecode().addStep("flatMap", flatMapTraversal);
        return this.asAdmin().addStep((Step)new TraversalFlatMapStep(this.asAdmin(), flatMapTraversal));
    }

    default public GraphTraversal<S, Object> id() {
        this.asAdmin().getBytecode().addStep("id", new Object[0]);
        return this.asAdmin().addStep((Step)new IdStep(this.asAdmin()));
    }

    default public GraphTraversal<S, String> label() {
        this.asAdmin().getBytecode().addStep("label", new Object[0]);
        return this.asAdmin().addStep((Step)new LabelStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> identity() {
        this.asAdmin().getBytecode().addStep("identity", new Object[0]);
        return this.asAdmin().addStep((Step)new IdentityStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> constant(E2 e) {
        this.asAdmin().getBytecode().addStep("constant", e);
        return this.asAdmin().addStep((Step)new ConstantStep(this.asAdmin(), e));
    }

    default public GraphTraversal<S, Vertex> V(Object ... vertexIdsOrElements) {
        this.asAdmin().getBytecode().addStep("V", vertexIdsOrElements);
        return this.asAdmin().addStep((Step)new GraphStep(this.asAdmin(), Vertex.class, false, vertexIdsOrElements));
    }

    default public GraphTraversal<S, Vertex> to(Direction direction, String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("to", new Object[]{direction, edgeLabels});
        return this.asAdmin().addStep(new VertexStep<Vertex>(this.asAdmin(), Vertex.class, direction, edgeLabels));
    }

    default public GraphTraversal<S, Vertex> out(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("out", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Vertex>(this.asAdmin(), Vertex.class, Direction.OUT, edgeLabels));
    }

    default public GraphTraversal<S, Vertex> in(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("in", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Vertex>(this.asAdmin(), Vertex.class, Direction.IN, edgeLabels));
    }

    default public GraphTraversal<S, Vertex> both(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("both", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Vertex>(this.asAdmin(), Vertex.class, Direction.BOTH, edgeLabels));
    }

    default public GraphTraversal<S, Edge> toE(Direction direction, String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("toE", new Object[]{direction, edgeLabels});
        return this.asAdmin().addStep(new VertexStep<Edge>(this.asAdmin(), Edge.class, direction, edgeLabels));
    }

    default public GraphTraversal<S, Edge> outE(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("outE", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Edge>(this.asAdmin(), Edge.class, Direction.OUT, edgeLabels));
    }

    default public GraphTraversal<S, Edge> inE(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("inE", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Edge>(this.asAdmin(), Edge.class, Direction.IN, edgeLabels));
    }

    default public GraphTraversal<S, Edge> bothE(String ... edgeLabels) {
        this.asAdmin().getBytecode().addStep("bothE", edgeLabels);
        return this.asAdmin().addStep(new VertexStep<Edge>(this.asAdmin(), Edge.class, Direction.BOTH, edgeLabels));
    }

    default public GraphTraversal<S, Vertex> toV(Direction direction) {
        this.asAdmin().getBytecode().addStep("toV", new Object[]{direction});
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), direction));
    }

    default public GraphTraversal<S, Vertex> inV() {
        this.asAdmin().getBytecode().addStep("inV", new Object[0]);
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.IN));
    }

    default public GraphTraversal<S, Vertex> outV() {
        this.asAdmin().getBytecode().addStep("outV", new Object[0]);
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.OUT));
    }

    default public GraphTraversal<S, Vertex> bothV() {
        this.asAdmin().getBytecode().addStep("bothV", new Object[0]);
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.BOTH));
    }

    default public GraphTraversal<S, Vertex> otherV() {
        this.asAdmin().getBytecode().addStep("otherV", new Object[0]);
        return this.asAdmin().addStep((Step)new EdgeOtherVertexStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> order() {
        this.asAdmin().getBytecode().addStep("order", new Object[0]);
        return this.asAdmin().addStep((Step)new OrderGlobalStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> order(Scope scope) {
        this.asAdmin().getBytecode().addStep("order", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new OrderGlobalStep(this.asAdmin()) : new OrderLocalStep(this.asAdmin())));
    }

    default public <E2> GraphTraversal<S, ? extends Property<E2>> properties(String ... propertyKeys) {
        this.asAdmin().getBytecode().addStep("properties", propertyKeys);
        return this.asAdmin().addStep((Step)new PropertiesStep(this.asAdmin(), PropertyType.PROPERTY, propertyKeys));
    }

    default public <E2> GraphTraversal<S, E2> values(String ... propertyKeys) {
        this.asAdmin().getBytecode().addStep("values", propertyKeys);
        return this.asAdmin().addStep((Step)new PropertiesStep(this.asAdmin(), PropertyType.VALUE, propertyKeys));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> propertyMap(String ... propertyKeys) {
        this.asAdmin().getBytecode().addStep("propertyMap", propertyKeys);
        return this.asAdmin().addStep((Step)new PropertyMapStep(this.asAdmin(), false, PropertyType.PROPERTY, propertyKeys));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> valueMap(String ... propertyKeys) {
        this.asAdmin().getBytecode().addStep("valueMap", propertyKeys);
        return this.asAdmin().addStep((Step)new PropertyMapStep(this.asAdmin(), false, PropertyType.VALUE, propertyKeys));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> valueMap(boolean includeTokens, String ... propertyKeys) {
        this.asAdmin().getBytecode().addStep("valueMap", includeTokens, propertyKeys);
        return this.asAdmin().addStep((Step)new PropertyMapStep(this.asAdmin(), includeTokens, PropertyType.VALUE, propertyKeys));
    }

    @Deprecated
    default public <E2> GraphTraversal<S, E2> mapValues() {
        return this.select(Column.values).unfold();
    }

    @Deprecated
    default public <E2> GraphTraversal<S, E2> mapKeys() {
        return this.select(Column.keys).unfold();
    }

    default public GraphTraversal<S, String> key() {
        this.asAdmin().getBytecode().addStep("key", new Object[0]);
        return this.asAdmin().addStep((Step)new PropertyKeyStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> value() {
        this.asAdmin().getBytecode().addStep("value", new Object[0]);
        return this.asAdmin().addStep((Step)new PropertyValueStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Path> path() {
        this.asAdmin().getBytecode().addStep("path", new Object[0]);
        return this.asAdmin().addStep((Step)new PathStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> match(Traversal<?, ?> ... matchTraversals) {
        this.asAdmin().getBytecode().addStep("match", matchTraversals);
        return this.asAdmin().addStep((Step)new MatchStep(this.asAdmin(), ConnectiveStep.Connective.AND, matchTraversals));
    }

    default public <E2> GraphTraversal<S, E2> sack() {
        this.asAdmin().getBytecode().addStep("sack", new Object[0]);
        return this.asAdmin().addStep((Step)new SackStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Integer> loops() {
        this.asAdmin().getBytecode().addStep("loops", new Object[0]);
        return this.asAdmin().addStep((Step)new LoopsStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> project(String projectKey, String ... otherProjectKeys) {
        String[] projectKeys = new String[otherProjectKeys.length + 1];
        projectKeys[0] = projectKey;
        System.arraycopy(otherProjectKeys, 0, projectKeys, 1, otherProjectKeys.length);
        this.asAdmin().getBytecode().addStep("project", projectKey, otherProjectKeys);
        return this.asAdmin().addStep((Step)new ProjectStep(this.asAdmin(), projectKeys));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> select(Pop pop, String selectKey1, String selectKey2, String ... otherSelectKeys) {
        String[] selectKeys = new String[otherSelectKeys.length + 2];
        selectKeys[0] = selectKey1;
        selectKeys[1] = selectKey2;
        System.arraycopy(otherSelectKeys, 0, selectKeys, 2, otherSelectKeys.length);
        this.asAdmin().getBytecode().addStep("select", new Object[]{pop, selectKey1, selectKey2, otherSelectKeys});
        return this.asAdmin().addStep((Step)new SelectStep(this.asAdmin(), pop, selectKeys));
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> select(String selectKey1, String selectKey2, String ... otherSelectKeys) {
        String[] selectKeys = new String[otherSelectKeys.length + 2];
        selectKeys[0] = selectKey1;
        selectKeys[1] = selectKey2;
        System.arraycopy(otherSelectKeys, 0, selectKeys, 2, otherSelectKeys.length);
        this.asAdmin().getBytecode().addStep("select", selectKey1, selectKey2, otherSelectKeys);
        return this.asAdmin().addStep((Step)new SelectStep(this.asAdmin(), null, selectKeys));
    }

    default public <E2> GraphTraversal<S, E2> select(Pop pop, String selectKey) {
        this.asAdmin().getBytecode().addStep("select", new Object[]{pop, selectKey});
        return this.asAdmin().addStep((Step)new SelectOneStep(this.asAdmin(), pop, selectKey));
    }

    default public <E2> GraphTraversal<S, E2> select(String selectKey) {
        this.asAdmin().getBytecode().addStep("select", selectKey);
        return this.asAdmin().addStep((Step)new SelectOneStep(this.asAdmin(), null, selectKey));
    }

    default public <E2> GraphTraversal<S, Collection<E2>> select(Column column) {
        this.asAdmin().getBytecode().addStep("select", column);
        return this.asAdmin().addStep((Step)new TraversalMapStep(this.asAdmin(), new ColumnTraversal(column)));
    }

    default public <E2> GraphTraversal<S, E2> unfold() {
        this.asAdmin().getBytecode().addStep("unfold", new Object[0]);
        return this.asAdmin().addStep((Step)new UnfoldStep(this.asAdmin()));
    }

    default public GraphTraversal<S, List<E>> fold() {
        this.asAdmin().getBytecode().addStep("fold", new Object[0]);
        return this.asAdmin().addStep((Step)new FoldStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> fold(E2 seed, BiFunction<E2, E, E2> foldFunction) {
        this.asAdmin().getBytecode().addStep("fold", seed, foldFunction);
        return this.asAdmin().addStep(new FoldStep<E, E2>(this.asAdmin(), new ConstantSupplier<E2>(seed), foldFunction));
    }

    default public GraphTraversal<S, Long> count() {
        this.asAdmin().getBytecode().addStep("count", new Object[0]);
        return this.asAdmin().addStep((Step)new CountGlobalStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Long> count(Scope scope) {
        this.asAdmin().getBytecode().addStep("count", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new CountGlobalStep(this.asAdmin()) : new CountLocalStep(this.asAdmin())));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> sum() {
        this.asAdmin().getBytecode().addStep("sum", new Object[0]);
        return this.asAdmin().addStep((Step)new SumGlobalStep(this.asAdmin()));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> sum(Scope scope) {
        this.asAdmin().getBytecode().addStep("sum", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new SumGlobalStep(this.asAdmin()) : new SumLocalStep(this.asAdmin())));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> max() {
        this.asAdmin().getBytecode().addStep("max", new Object[0]);
        return this.asAdmin().addStep((Step)new MaxGlobalStep(this.asAdmin()));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> max(Scope scope) {
        this.asAdmin().getBytecode().addStep("max", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new MaxGlobalStep(this.asAdmin()) : new MaxLocalStep(this.asAdmin())));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> min() {
        this.asAdmin().getBytecode().addStep("min", new Object[0]);
        return this.asAdmin().addStep((Step)new MinGlobalStep(this.asAdmin()));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> min(Scope scope) {
        this.asAdmin().getBytecode().addStep("min", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new MinGlobalStep(this.asAdmin()) : new MinLocalStep(this.asAdmin())));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> mean() {
        this.asAdmin().getBytecode().addStep("mean", new Object[0]);
        return this.asAdmin().addStep((Step)new MeanGlobalStep(this.asAdmin()));
    }

    default public <E2 extends Number> GraphTraversal<S, E2> mean(Scope scope) {
        this.asAdmin().getBytecode().addStep("mean", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new MeanGlobalStep(this.asAdmin()) : new MeanLocalStep(this.asAdmin())));
    }

    default public <K, V> GraphTraversal<S, Map<K, V>> group() {
        this.asAdmin().getBytecode().addStep("group", new Object[0]);
        return this.asAdmin().addStep((Step)new GroupStep(this.asAdmin()));
    }

    @Deprecated
    default public <K, V> GraphTraversal<S, Map<K, V>> groupV3d0() {
        this.asAdmin().getBytecode().addStep("groupV3d0", new Object[0]);
        return this.asAdmin().addStep((Step)new GroupStepV3d0(this.asAdmin()));
    }

    default public <K> GraphTraversal<S, Map<K, Long>> groupCount() {
        this.asAdmin().getBytecode().addStep("groupCount", new Object[0]);
        return this.asAdmin().addStep((Step)new GroupCountStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Tree> tree() {
        this.asAdmin().getBytecode().addStep("tree", new Object[0]);
        return this.asAdmin().addStep((Step)new TreeStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Vertex> addV(String vertexLabel) {
        this.asAdmin().getBytecode().addStep("addV", vertexLabel);
        return this.asAdmin().addStep((Step)new AddVertexStep(this.asAdmin(), vertexLabel));
    }

    default public GraphTraversal<S, Vertex> addV() {
        this.asAdmin().getBytecode().addStep("addV", new Object[0]);
        return this.asAdmin().addStep((Step)new AddVertexStep(this.asAdmin(), null));
    }

    @Deprecated
    default public GraphTraversal<S, Vertex> addV(Object ... propertyKeyValues) {
        this.addV();
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            this.property(propertyKeyValues[i], propertyKeyValues[i + 1], new Object[0]);
        }
        return this;
    }

    default public GraphTraversal<S, Edge> addE(String edgeLabel) {
        this.asAdmin().getBytecode().addStep("addE", edgeLabel);
        return this.asAdmin().addStep((Step)new AddEdgeStep(this.asAdmin(), edgeLabel));
    }

    default public GraphTraversal<S, E> to(String toStepLabel) {
        this.asAdmin().getBytecode().addStep("to", toStepLabel);
        ((FromToModulating)((Object)this.asAdmin().getEndStep())).addTo(toStepLabel);
        return this;
    }

    default public GraphTraversal<S, E> from(String fromStepLabel) {
        this.asAdmin().getBytecode().addStep("from", fromStepLabel);
        ((FromToModulating)((Object)this.asAdmin().getEndStep())).addFrom(fromStepLabel);
        return this;
    }

    default public GraphTraversal<S, E> to(Traversal<E, Vertex> toVertex) {
        this.asAdmin().getBytecode().addStep("to", toVertex);
        ((FromToModulating)((Object)this.asAdmin().getEndStep())).addTo(toVertex.asAdmin());
        return this;
    }

    default public GraphTraversal<S, E> from(Traversal<E, Vertex> fromVertex) {
        this.asAdmin().getBytecode().addStep("from", fromVertex);
        ((FromToModulating)((Object)this.asAdmin().getEndStep())).addFrom(fromVertex.asAdmin());
        return this;
    }

    @Deprecated
    default public GraphTraversal<S, Edge> addE(Direction direction, String firstVertexKeyOrEdgeLabel, String edgeLabelOrSecondVertexKey, Object ... propertyKeyValues) {
        if (propertyKeyValues.length % 2 == 0) {
            this.addE(firstVertexKeyOrEdgeLabel);
            if (direction.equals((Object)Direction.OUT)) {
                this.to(edgeLabelOrSecondVertexKey);
            } else {
                this.from(edgeLabelOrSecondVertexKey);
            }
            for (int i = 0; i < propertyKeyValues.length; i += 2) {
                this.property(propertyKeyValues[i], propertyKeyValues[i + 1], new Object[0]);
            }
            return this;
        }
        this.addE(edgeLabelOrSecondVertexKey);
        if (direction.equals((Object)Direction.OUT)) {
            this.from(firstVertexKeyOrEdgeLabel).to((String)propertyKeyValues[0]);
        } else {
            this.to(firstVertexKeyOrEdgeLabel).from((String)propertyKeyValues[0]);
        }
        for (int i = 1; i < propertyKeyValues.length; i += 2) {
            this.property(propertyKeyValues[i], propertyKeyValues[i + 1], new Object[0]);
        }
        return this;
    }

    @Deprecated
    default public GraphTraversal<S, Edge> addOutE(String firstVertexKeyOrEdgeLabel, String edgeLabelOrSecondVertexKey, Object ... propertyKeyValues) {
        return this.addE(Direction.OUT, firstVertexKeyOrEdgeLabel, edgeLabelOrSecondVertexKey, propertyKeyValues);
    }

    @Deprecated
    default public GraphTraversal<S, Edge> addInE(String firstVertexKeyOrEdgeLabel, String edgeLabelOrSecondVertexKey, Object ... propertyKeyValues) {
        return this.addE(Direction.IN, firstVertexKeyOrEdgeLabel, edgeLabelOrSecondVertexKey, propertyKeyValues);
    }

    default public GraphTraversal<S, E> filter(Predicate<Traverser<E>> predicate) {
        this.asAdmin().getBytecode().addStep("filter", predicate);
        return this.asAdmin().addStep((Step)new LambdaFilterStep(this.asAdmin(), predicate));
    }

    default public GraphTraversal<S, E> filter(Traversal<?, ?> filterTraversal) {
        this.asAdmin().getBytecode().addStep("filter", filterTraversal);
        return this.asAdmin().addStep((Step)new TraversalFilterStep(this.asAdmin(), filterTraversal));
    }

    default public GraphTraversal<S, E> or(Traversal<?, ?> ... orTraversals) {
        this.asAdmin().getBytecode().addStep("or", orTraversals);
        return this.asAdmin().addStep((Step)new OrStep(this.asAdmin(), orTraversals));
    }

    default public GraphTraversal<S, E> and(Traversal<?, ?> ... andTraversals) {
        this.asAdmin().getBytecode().addStep("and", andTraversals);
        return this.asAdmin().addStep((Step)new AndStep(this.asAdmin(), andTraversals));
    }

    default public GraphTraversal<S, E> inject(E ... injections) {
        this.asAdmin().getBytecode().addStep("inject", injections);
        return this.asAdmin().addStep(new InjectStep<E>(this.asAdmin(), injections));
    }

    default public GraphTraversal<S, E> dedup(Scope scope, String ... dedupLabels) {
        this.asAdmin().getBytecode().addStep("dedup", new Object[]{scope, dedupLabels});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new DedupGlobalStep(this.asAdmin(), dedupLabels) : new DedupLocalStep(this.asAdmin())));
    }

    default public GraphTraversal<S, E> dedup(String ... dedupLabels) {
        this.asAdmin().getBytecode().addStep("dedup", dedupLabels);
        return this.asAdmin().addStep((Step)new DedupGlobalStep(this.asAdmin(), dedupLabels));
    }

    default public GraphTraversal<S, E> where(String startKey, P<String> predicate) {
        this.asAdmin().getBytecode().addStep("where", startKey, predicate);
        return this.asAdmin().addStep((Step)new WherePredicateStep(this.asAdmin(), Optional.ofNullable(startKey), predicate));
    }

    default public GraphTraversal<S, E> where(P<String> predicate) {
        this.asAdmin().getBytecode().addStep("where", predicate);
        return this.asAdmin().addStep((Step)new WherePredicateStep(this.asAdmin(), Optional.empty(), predicate));
    }

    default public GraphTraversal<S, E> where(Traversal<?, ?> whereTraversal) {
        this.asAdmin().getBytecode().addStep("where", whereTraversal);
        return TraversalHelper.getVariableLocations(whereTraversal.asAdmin()).isEmpty() ? this.asAdmin().addStep((Step)new TraversalFilterStep(this.asAdmin(), whereTraversal)) : this.asAdmin().addStep((Step)new WhereTraversalStep(this.asAdmin(), whereTraversal));
    }

    default public GraphTraversal<S, E> has(String propertyKey, P<?> predicate) {
        this.asAdmin().getBytecode().addStep("has", propertyKey, predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, predicate)));
    }

    default public GraphTraversal<S, E> has(T accessor, P<?> predicate) {
        this.asAdmin().getBytecode().addStep("has", accessor, predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(accessor.getAccessor(), predicate)));
    }

    default public GraphTraversal<S, E> has(String propertyKey, Object value) {
        if (value instanceof P) {
            return this.has(propertyKey, (P)value);
        }
        if (value instanceof Traversal) {
            return this.has(propertyKey, (Traversal)value);
        }
        this.asAdmin().getBytecode().addStep("has", propertyKey, value);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, P.eq(value))));
    }

    default public GraphTraversal<S, E> has(T accessor, Object value) {
        if (value instanceof P) {
            return this.has(accessor, (P)value);
        }
        if (value instanceof Traversal) {
            return this.has(accessor, (Traversal)value);
        }
        this.asAdmin().getBytecode().addStep("has", accessor, value);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(accessor.getAccessor(), P.eq(value))));
    }

    default public GraphTraversal<S, E> has(String label, String propertyKey, P<?> predicate) {
        this.asAdmin().getBytecode().addStep("has", label, propertyKey, predicate);
        TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.label.getAccessor(), P.eq(label)));
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, predicate)));
    }

    default public GraphTraversal<S, E> has(String label, String propertyKey, Object value) {
        this.asAdmin().getBytecode().addStep("has", label, propertyKey, value);
        TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.label.getAccessor(), P.eq(label)));
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, value instanceof P ? (P<Object>)value : P.eq(value))));
    }

    default public GraphTraversal<S, E> has(T accessor, Traversal<?, ?> propertyTraversal) {
        this.asAdmin().getBytecode().addStep("has", accessor, propertyTraversal);
        return this.asAdmin().addStep((Step)new TraversalFilterStep(this.asAdmin(), propertyTraversal.asAdmin().addStep(0, new PropertiesStep(propertyTraversal.asAdmin(), PropertyType.VALUE, accessor.getAccessor()))));
    }

    default public GraphTraversal<S, E> has(String propertyKey, Traversal<?, ?> propertyTraversal) {
        this.asAdmin().getBytecode().addStep("has", propertyKey, propertyTraversal);
        return this.asAdmin().addStep((Step)new TraversalFilterStep(this.asAdmin(), propertyTraversal.asAdmin().addStep(0, new PropertiesStep(propertyTraversal.asAdmin(), PropertyType.VALUE, propertyKey))));
    }

    default public GraphTraversal<S, E> has(String propertyKey) {
        this.asAdmin().getBytecode().addStep("has", propertyKey);
        return this.asAdmin().addStep((Step)new TraversalFilterStep(this.asAdmin(), __.values(propertyKey)));
    }

    default public GraphTraversal<S, E> hasNot(String propertyKey) {
        this.asAdmin().getBytecode().addStep("hasNot", propertyKey);
        return this.asAdmin().addStep((Step)new NotStep(this.asAdmin(), __.values(propertyKey)));
    }

    default public GraphTraversal<S, E> hasLabel(String label, String ... otherLabels) {
        Object[] labels = new String[otherLabels.length + 1];
        labels[0] = label;
        System.arraycopy(otherLabels, 0, labels, 1, otherLabels.length);
        this.asAdmin().getBytecode().addStep("hasLabel", labels);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.label.getAccessor(), labels.length == 1 ? P.eq(labels[0]) : P.within(labels))));
    }

    default public GraphTraversal<S, E> hasLabel(P<String> predicate) {
        this.asAdmin().getBytecode().addStep("hasLabel", predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.label.getAccessor(), predicate)));
    }

    default public GraphTraversal<S, E> hasId(Object id, Object ... otherIds) {
        if (id instanceof P) {
            return this.hasId((P)id);
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        if (id instanceof Object[]) {
            for (Object i : (Object[])id) {
                ids.add(i);
            }
        } else {
            ids.add(id);
        }
        for (Object i : otherIds) {
            if (i.getClass().isArray()) {
                for (Object ii : (Object[])i) {
                    ids.add(ii);
                }
                continue;
            }
            ids.add(i);
        }
        this.asAdmin().getBytecode().addStep("hasId", ids.toArray());
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.id.getAccessor(), ids.size() == 1 ? P.eq(ids.get(0)) : P.within(ids))));
    }

    default public GraphTraversal<S, E> hasId(P<Object> predicate) {
        this.asAdmin().getBytecode().addStep("hasId", predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.id.getAccessor(), predicate)));
    }

    default public GraphTraversal<S, E> hasKey(String label, String ... otherLabels) {
        Object[] labels = new String[otherLabels.length + 1];
        labels[0] = label;
        System.arraycopy(otherLabels, 0, labels, 1, otherLabels.length);
        this.asAdmin().getBytecode().addStep("hasKey", labels);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.key.getAccessor(), labels.length == 1 ? P.eq(labels[0]) : P.within(labels))));
    }

    default public GraphTraversal<S, E> hasKey(P<String> predicate) {
        this.asAdmin().getBytecode().addStep("hasKey", predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.key.getAccessor(), predicate)));
    }

    default public GraphTraversal<S, E> hasValue(Object value, Object ... otherValues) {
        if (value instanceof P) {
            return this.hasValue((P)value);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                values.add(v);
            }
        } else {
            values.add(value);
        }
        for (Object v : otherValues) {
            if (v instanceof Object[]) {
                for (Object vv : (Object[])v) {
                    values.add(vv);
                }
                continue;
            }
            values.add(v);
        }
        this.asAdmin().getBytecode().addStep("hasValue", values.toArray());
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.value.getAccessor(), values.size() == 1 ? P.eq(values.get(0)) : P.within(values))));
    }

    default public GraphTraversal<S, E> hasValue(P<Object> predicate) {
        this.asAdmin().getBytecode().addStep("hasValue", predicate);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(T.value.getAccessor(), predicate)));
    }

    default public GraphTraversal<S, E> is(P<E> predicate) {
        this.asAdmin().getBytecode().addStep("is", predicate);
        return this.asAdmin().addStep(new IsStep<E>(this.asAdmin(), predicate));
    }

    default public GraphTraversal<S, E> is(Object value) {
        this.asAdmin().getBytecode().addStep("is", value);
        return this.asAdmin().addStep(new IsStep<Object>(this.asAdmin(), value instanceof P ? (P<Object>)value : P.eq(value)));
    }

    default public GraphTraversal<S, E> not(Traversal<?, ?> notTraversal) {
        this.asAdmin().getBytecode().addStep("not", notTraversal);
        return this.asAdmin().addStep((Step)new NotStep(this.asAdmin(), notTraversal));
    }

    default public GraphTraversal<S, E> coin(double probability) {
        this.asAdmin().getBytecode().addStep("coin", probability);
        return this.asAdmin().addStep((Step)new CoinStep(this.asAdmin(), probability));
    }

    default public GraphTraversal<S, E> range(long low, long high) {
        this.asAdmin().getBytecode().addStep("range", low, high);
        return this.asAdmin().addStep((Step)new RangeGlobalStep(this.asAdmin(), low, high));
    }

    default public <E2> GraphTraversal<S, E2> range(Scope scope, long low, long high) {
        this.asAdmin().getBytecode().addStep("range", new Object[]{scope, low, high});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new RangeGlobalStep(this.asAdmin(), low, high) : new RangeLocalStep(this.asAdmin(), low, high)));
    }

    default public GraphTraversal<S, E> limit(long limit) {
        this.asAdmin().getBytecode().addStep("limit", limit);
        return this.asAdmin().addStep((Step)new RangeGlobalStep(this.asAdmin(), 0L, limit));
    }

    default public <E2> GraphTraversal<S, E2> limit(Scope scope, long limit) {
        this.asAdmin().getBytecode().addStep("limit", new Object[]{scope, limit});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new RangeGlobalStep(this.asAdmin(), 0L, limit) : new RangeLocalStep(this.asAdmin(), 0L, limit)));
    }

    default public GraphTraversal<S, E> tail() {
        this.asAdmin().getBytecode().addStep("tail", new Object[0]);
        return this.asAdmin().addStep((Step)new TailGlobalStep(this.asAdmin(), 1L));
    }

    default public GraphTraversal<S, E> tail(long limit) {
        this.asAdmin().getBytecode().addStep("tail", limit);
        return this.asAdmin().addStep((Step)new TailGlobalStep(this.asAdmin(), limit));
    }

    default public <E2> GraphTraversal<S, E2> tail(Scope scope) {
        this.asAdmin().getBytecode().addStep("tail", new Object[]{scope});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new TailGlobalStep(this.asAdmin(), 1L) : new TailLocalStep(this.asAdmin(), 1L)));
    }

    default public <E2> GraphTraversal<S, E2> tail(Scope scope, long limit) {
        this.asAdmin().getBytecode().addStep("tail", new Object[]{scope, limit});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new TailGlobalStep(this.asAdmin(), limit) : new TailLocalStep(this.asAdmin(), limit)));
    }

    default public GraphTraversal<S, E> timeLimit(long timeLimit) {
        this.asAdmin().getBytecode().addStep("timeLimit", timeLimit);
        return this.asAdmin().addStep((Step)new TimeLimitStep(this.asAdmin(), timeLimit));
    }

    default public GraphTraversal<S, E> simplePath() {
        this.asAdmin().getBytecode().addStep("simplePath", new Object[0]);
        return this.asAdmin().addStep((Step)new PathFilterStep(this.asAdmin(), true));
    }

    default public GraphTraversal<S, E> cyclicPath() {
        this.asAdmin().getBytecode().addStep("cyclicPath", new Object[0]);
        return this.asAdmin().addStep((Step)new PathFilterStep(this.asAdmin(), false));
    }

    default public GraphTraversal<S, E> sample(int amountToSample) {
        this.asAdmin().getBytecode().addStep("sample", amountToSample);
        return this.asAdmin().addStep((Step)new SampleGlobalStep(this.asAdmin(), amountToSample));
    }

    default public GraphTraversal<S, E> sample(Scope scope, int amountToSample) {
        this.asAdmin().getBytecode().addStep("sample", new Object[]{scope, amountToSample});
        return this.asAdmin().addStep((Step)(scope.equals((Object)Scope.global) ? new SampleGlobalStep(this.asAdmin(), amountToSample) : new SampleLocalStep(this.asAdmin(), amountToSample)));
    }

    default public GraphTraversal<S, E> drop() {
        this.asAdmin().getBytecode().addStep("drop", new Object[0]);
        return this.asAdmin().addStep((Step)new DropStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> sideEffect(Consumer<Traverser<E>> consumer) {
        this.asAdmin().getBytecode().addStep("sideEffect", consumer);
        return this.asAdmin().addStep((Step)new LambdaSideEffectStep(this.asAdmin(), consumer));
    }

    default public GraphTraversal<S, E> sideEffect(Traversal<?, ?> sideEffectTraversal) {
        this.asAdmin().getBytecode().addStep("sideEffect", sideEffectTraversal);
        return this.asAdmin().addStep((Step)new TraversalSideEffectStep(this.asAdmin(), sideEffectTraversal));
    }

    default public <E2> GraphTraversal<S, E2> cap(String sideEffectKey, String ... sideEffectKeys) {
        this.asAdmin().getBytecode().addStep("cap", sideEffectKey, sideEffectKeys);
        return this.asAdmin().addStep((Step)new SideEffectCapStep(this.asAdmin(), sideEffectKey, sideEffectKeys));
    }

    default public GraphTraversal<S, Edge> subgraph(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("subgraph", sideEffectKey);
        return this.asAdmin().addStep((Step)new SubgraphStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> aggregate(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("aggregate", sideEffectKey);
        return this.asAdmin().addStep((Step)new AggregateStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> group(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("group", sideEffectKey);
        return this.asAdmin().addStep((Step)new GroupSideEffectStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> groupV3d0(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("groupV3d0", sideEffectKey);
        return this.asAdmin().addStep((Step)new GroupSideEffectStepV3d0(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> groupCount(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("groupCount", sideEffectKey);
        return this.asAdmin().addStep((Step)new GroupCountSideEffectStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> tree(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("tree", sideEffectKey);
        return this.asAdmin().addStep((Step)new TreeSideEffectStep(this.asAdmin(), sideEffectKey));
    }

    default public <V, U> GraphTraversal<S, E> sack(BiFunction<V, U, V> sackOperator) {
        this.asAdmin().getBytecode().addStep("sack", sackOperator);
        return this.asAdmin().addStep((Step)new SackValueStep(this.asAdmin(), sackOperator));
    }

    @Deprecated
    default public <V, U> GraphTraversal<S, E> sack(BiFunction<V, U, V> sackOperator, String elementPropertyKey) {
        return this.sack(sackOperator).by(elementPropertyKey);
    }

    default public GraphTraversal<S, E> store(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("store", sideEffectKey);
        return this.asAdmin().addStep((Step)new StoreStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> profile(String sideEffectKey) {
        this.asAdmin().getBytecode().addStep("profile", sideEffectKey);
        return this.asAdmin().addStep((Step)new ProfileSideEffectStep(this.asAdmin(), sideEffectKey));
    }

    @Override
    default public GraphTraversal<S, TraversalMetrics> profile() {
        return (GraphTraversal)Traversal.super.profile();
    }

    default public GraphTraversal<S, E> property(VertexProperty.Cardinality cardinality, Object key, Object value, Object ... keyValues) {
        if (null == cardinality) {
            this.asAdmin().getBytecode().addStep("property", key, value, keyValues);
        } else {
            this.asAdmin().getBytecode().addStep("property", new Object[]{cardinality, key, value, keyValues});
        }
        Step endStep = this.asAdmin().getEndStep();
        if ((endStep instanceof AddVertexStep || endStep instanceof AddEdgeStep || endStep instanceof AddVertexStartStep) && keyValues.length == 0 && null == cardinality) {
            ((Mutating)((Object)endStep)).addPropertyMutations(key, value);
        } else {
            this.asAdmin().addStep((Step)new AddPropertyStep(this.asAdmin(), cardinality, key, value));
            ((AddPropertyStep)this.asAdmin().getEndStep()).addPropertyMutations(keyValues);
        }
        return this;
    }

    default public GraphTraversal<S, E> property(Object key, Object value, Object ... keyValues) {
        return key instanceof VertexProperty.Cardinality ? this.property((VertexProperty.Cardinality)((Object)key), value, keyValues[0], keyValues.length > 1 ? Arrays.copyOfRange(keyValues, 1, keyValues.length) : new Object[]{}) : this.property(null, key, value, keyValues);
    }

    default public <M, E2> GraphTraversal<S, E2> branch(Traversal<?, M> branchTraversal) {
        this.asAdmin().getBytecode().addStep("branch", branchTraversal);
        BranchStep branchStep = new BranchStep(this.asAdmin());
        branchStep.setBranchTraversal((Traversal.Admin)branchTraversal);
        return this.asAdmin().addStep((Step)branchStep);
    }

    default public <M, E2> GraphTraversal<S, E2> branch(Function<Traverser<E>, M> function) {
        this.asAdmin().getBytecode().addStep("branch", function);
        BranchStep branchStep = new BranchStep(this.asAdmin());
        branchStep.setBranchTraversal((Traversal.Admin)((Object)__.map(function)));
        return this.asAdmin().addStep((Step)branchStep);
    }

    default public <M, E2> GraphTraversal<S, E2> choose(Traversal<?, M> choiceTraversal) {
        this.asAdmin().getBytecode().addStep("choose", choiceTraversal);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)choiceTraversal));
    }

    default public <E2> GraphTraversal<S, E2> choose(Traversal<?, ?> traversalPredicate, Traversal<?, E2> trueChoice, Traversal<?, E2> falseChoice) {
        this.asAdmin().getBytecode().addStep("choose", traversalPredicate, trueChoice, falseChoice);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)traversalPredicate, (Traversal.Admin)trueChoice, (Traversal.Admin)falseChoice));
    }

    default public <E2> GraphTraversal<S, E2> choose(Traversal<?, ?> traversalPredicate, Traversal<?, E2> trueChoice) {
        this.asAdmin().getBytecode().addStep("choose", traversalPredicate, trueChoice);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)traversalPredicate, (Traversal.Admin)trueChoice, (Traversal.Admin)((Object)__.identity())));
    }

    default public <M, E2> GraphTraversal<S, E2> choose(Function<E, M> choiceFunction) {
        this.asAdmin().getBytecode().addStep("choose", choiceFunction);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)((Object)__.map(new FunctionTraverser<E, M>(choiceFunction)))));
    }

    default public <E2> GraphTraversal<S, E2> choose(Predicate<E> choosePredicate, Traversal<?, E2> trueChoice, Traversal<?, E2> falseChoice) {
        this.asAdmin().getBytecode().addStep("choose", choosePredicate, trueChoice, falseChoice);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)((Object)__.filter(new PredicateTraverser<E>(choosePredicate))), (Traversal.Admin)trueChoice, (Traversal.Admin)falseChoice));
    }

    default public <E2> GraphTraversal<S, E2> choose(Predicate<E> choosePredicate, Traversal<?, E2> trueChoice) {
        this.asAdmin().getBytecode().addStep("choose", choosePredicate, trueChoice);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)((Object)__.filter(new PredicateTraverser<E>(choosePredicate))), (Traversal.Admin)trueChoice, (Traversal.Admin)((Object)__.identity())));
    }

    default public <E2> GraphTraversal<S, E2> optional(Traversal<?, E2> optionalTraversal) {
        this.asAdmin().getBytecode().addStep("optional", optionalTraversal);
        return this.asAdmin().addStep((Step)new ChooseStep(this.asAdmin(), (Traversal.Admin)optionalTraversal, optionalTraversal.asAdmin().clone(), (Traversal.Admin)((Object)__.identity())));
    }

    default public <E2> GraphTraversal<S, E2> union(Traversal<?, E2> ... unionTraversals) {
        this.asAdmin().getBytecode().addStep("union", unionTraversals);
        return this.asAdmin().addStep((Step)new UnionStep(this.asAdmin(), (Traversal.Admin[])Arrays.copyOf(unionTraversals, unionTraversals.length, Traversal.Admin[].class)));
    }

    default public <E2> GraphTraversal<S, E2> coalesce(Traversal<?, E2> ... coalesceTraversals) {
        this.asAdmin().getBytecode().addStep("coalesce", coalesceTraversals);
        return this.asAdmin().addStep((Step)new CoalesceStep(this.asAdmin(), (Traversal.Admin[])Arrays.copyOf(coalesceTraversals, coalesceTraversals.length, Traversal.Admin[].class)));
    }

    default public GraphTraversal<S, E> repeat(Traversal<?, E> repeatTraversal) {
        this.asAdmin().getBytecode().addStep("repeat", repeatTraversal);
        return RepeatStep.addRepeatToTraversal(this, (Traversal.Admin)repeatTraversal);
    }

    default public GraphTraversal<S, E> emit(Traversal<?, ?> emitTraversal) {
        this.asAdmin().getBytecode().addStep("emit", emitTraversal);
        return RepeatStep.addEmitToTraversal(this, (Traversal.Admin)emitTraversal);
    }

    default public GraphTraversal<S, E> emit(Predicate<Traverser<E>> emitPredicate) {
        this.asAdmin().getBytecode().addStep("emit", emitPredicate);
        return RepeatStep.addEmitToTraversal(this, (Traversal.Admin)((Object)__.filter(emitPredicate)));
    }

    default public GraphTraversal<S, E> emit() {
        this.asAdmin().getBytecode().addStep("emit", new Object[0]);
        return RepeatStep.addEmitToTraversal(this, TrueTraversal.instance());
    }

    default public GraphTraversal<S, E> until(Traversal<?, ?> untilTraversal) {
        this.asAdmin().getBytecode().addStep("until", untilTraversal);
        return RepeatStep.addUntilToTraversal(this, (Traversal.Admin)untilTraversal);
    }

    default public GraphTraversal<S, E> until(Predicate<Traverser<E>> untilPredicate) {
        this.asAdmin().getBytecode().addStep("until", untilPredicate);
        return RepeatStep.addUntilToTraversal(this, (Traversal.Admin)((Object)__.filter(untilPredicate)));
    }

    default public GraphTraversal<S, E> times(int maxLoops) {
        this.asAdmin().getBytecode().addStep("times", maxLoops);
        if (this.asAdmin().getEndStep() instanceof TimesModulating) {
            ((TimesModulating)((Object)this.asAdmin().getEndStep())).modulateTimes(maxLoops);
            return this;
        }
        return RepeatStep.addUntilToTraversal(this, new LoopTraversal(maxLoops));
    }

    default public <E2> GraphTraversal<S, E2> local(Traversal<?, E2> localTraversal) {
        this.asAdmin().getBytecode().addStep("local", localTraversal);
        return this.asAdmin().addStep((Step)new LocalStep(this.asAdmin(), localTraversal.asAdmin()));
    }

    default public GraphTraversal<S, E> pageRank() {
        return this.pageRank(0.85);
    }

    default public GraphTraversal<S, E> pageRank(double alpha) {
        this.asAdmin().getBytecode().addStep("pageRank", alpha);
        return this.asAdmin().addStep((Step)new PageRankVertexProgramStep(this.asAdmin(), alpha));
    }

    default public GraphTraversal<S, E> peerPressure() {
        this.asAdmin().getBytecode().addStep("peerPressure", new Object[0]);
        return this.asAdmin().addStep((Step)new PeerPressureVertexProgramStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> program(VertexProgram<?> vertexProgram) {
        return this.asAdmin().addStep((Step)new ProgramVertexProgramStep(this.asAdmin(), vertexProgram));
    }

    default public GraphTraversal<S, E> as(String stepLabel, String ... stepLabels) {
        this.asAdmin().getBytecode().addStep("as", stepLabel, stepLabels);
        if (this.asAdmin().getSteps().size() == 0) {
            this.asAdmin().addStep((Step)new StartStep(this.asAdmin()));
        }
        Step endStep = this.asAdmin().getEndStep();
        endStep.addLabel(stepLabel);
        for (String label : stepLabels) {
            endStep.addLabel(label);
        }
        return this;
    }

    default public GraphTraversal<S, E> barrier() {
        return this.barrier(Integer.MAX_VALUE);
    }

    default public GraphTraversal<S, E> barrier(int maxBarrierSize) {
        this.asAdmin().getBytecode().addStep("barrier", maxBarrierSize);
        return this.asAdmin().addStep((Step)new NoOpBarrierStep(this.asAdmin(), maxBarrierSize));
    }

    default public GraphTraversal<S, E> barrier(Consumer<TraverserSet<Object>> barrierConsumer) {
        this.asAdmin().getBytecode().addStep("barrier", barrierConsumer);
        return this.asAdmin().addStep((Step)new LambdaCollectingBarrierStep(this.asAdmin(), barrierConsumer, Integer.MAX_VALUE));
    }

    default public GraphTraversal<S, E> by() {
        this.asAdmin().getBytecode().addStep("by", new Object[0]);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy();
        return this;
    }

    default public GraphTraversal<S, E> by(Traversal<?, ?> traversal) {
        this.asAdmin().getBytecode().addStep("by", traversal);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(traversal.asAdmin());
        return this;
    }

    default public GraphTraversal<S, E> by(T token) {
        this.asAdmin().getBytecode().addStep("by", token);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(token);
        return this;
    }

    default public GraphTraversal<S, E> by(String key) {
        this.asAdmin().getBytecode().addStep("by", key);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(key);
        return this;
    }

    default public <V> GraphTraversal<S, E> by(Function<V, Object> function) {
        this.asAdmin().getBytecode().addStep("by", function);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(function);
        return this;
    }

    default public <V> GraphTraversal<S, E> by(Traversal<?, ?> traversal, Comparator<V> comparator) {
        this.asAdmin().getBytecode().addStep("by", traversal, comparator);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(traversal.asAdmin(), comparator);
        return this;
    }

    default public GraphTraversal<S, E> by(Comparator<E> comparator) {
        this.asAdmin().getBytecode().addStep("by", comparator);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(comparator);
        return this;
    }

    default public GraphTraversal<S, E> by(Order order) {
        this.asAdmin().getBytecode().addStep("by", order);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(order);
        return this;
    }

    default public <V> GraphTraversal<S, E> by(String key, Comparator<V> comparator) {
        this.asAdmin().getBytecode().addStep("by", key, comparator);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(key, comparator);
        return this;
    }

    default public <U> GraphTraversal<S, E> by(Function<U, Object> function, Comparator comparator) {
        this.asAdmin().getBytecode().addStep("by", function, comparator);
        ((ByModulating)((Object)this.asAdmin().getEndStep())).modulateBy(function, comparator);
        return this;
    }

    default public <M, E2> GraphTraversal<S, E> option(M pickToken, Traversal<E, E2> traversalOption) {
        this.asAdmin().getBytecode().addStep("option", pickToken, traversalOption);
        ((TraversalOptionParent)((Object)this.asAdmin().getEndStep())).addGlobalChildOption(pickToken, traversalOption.asAdmin());
        return this;
    }

    default public <E2> GraphTraversal<S, E> option(Traversal<E, E2> traversalOption) {
        this.asAdmin().getBytecode().addStep("option", traversalOption);
        return this.option(TraversalOptionParent.Pick.any, traversalOption.asAdmin());
    }

    @Override
    default public GraphTraversal<S, E> iterate() {
        Traversal.super.iterate();
        return this;
    }

    public static final class Symbols {
        public static final String map = "map";
        public static final String flatMap = "flatMap";
        public static final String id = "id";
        public static final String label = "label";
        public static final String identity = "identity";
        public static final String constant = "constant";
        public static final String V = "V";
        public static final String E = "E";
        public static final String to = "to";
        public static final String out = "out";
        public static final String in = "in";
        public static final String both = "both";
        public static final String toE = "toE";
        public static final String outE = "outE";
        public static final String inE = "inE";
        public static final String bothE = "bothE";
        public static final String toV = "toV";
        public static final String outV = "outV";
        public static final String inV = "inV";
        public static final String bothV = "bothV";
        public static final String otherV = "otherV";
        public static final String order = "order";
        public static final String properties = "properties";
        public static final String values = "values";
        public static final String propertyMap = "propertyMap";
        public static final String valueMap = "valueMap";
        public static final String select = "select";
        public static final String key = "key";
        public static final String value = "value";
        public static final String path = "path";
        public static final String match = "match";
        public static final String sack = "sack";
        public static final String loops = "loops";
        public static final String project = "project";
        public static final String unfold = "unfold";
        public static final String fold = "fold";
        public static final String count = "count";
        public static final String sum = "sum";
        public static final String max = "max";
        public static final String min = "min";
        public static final String mean = "mean";
        public static final String group = "group";
        @Deprecated
        public static final String groupV3d0 = "groupV3d0";
        public static final String groupCount = "groupCount";
        public static final String tree = "tree";
        public static final String addV = "addV";
        public static final String addE = "addE";
        public static final String from = "from";
        public static final String filter = "filter";
        public static final String or = "or";
        public static final String and = "and";
        public static final String inject = "inject";
        public static final String dedup = "dedup";
        public static final String where = "where";
        public static final String has = "has";
        public static final String hasNot = "hasNot";
        public static final String hasLabel = "hasLabel";
        public static final String hasId = "hasId";
        public static final String hasKey = "hasKey";
        public static final String hasValue = "hasValue";
        public static final String is = "is";
        public static final String not = "not";
        public static final String range = "range";
        public static final String limit = "limit";
        public static final String tail = "tail";
        public static final String coin = "coin";
        public static final String timeLimit = "timeLimit";
        public static final String simplePath = "simplePath";
        public static final String cyclicPath = "cyclicPath";
        public static final String sample = "sample";
        public static final String drop = "drop";
        public static final String sideEffect = "sideEffect";
        public static final String cap = "cap";
        public static final String property = "property";
        public static final String store = "store";
        public static final String aggregate = "aggregate";
        public static final String subgraph = "subgraph";
        public static final String barrier = "barrier";
        public static final String local = "local";
        public static final String emit = "emit";
        public static final String repeat = "repeat";
        public static final String until = "until";
        public static final String branch = "branch";
        public static final String union = "union";
        public static final String coalesce = "coalesce";
        public static final String choose = "choose";
        public static final String optional = "optional";
        public static final String pageRank = "pageRank";
        public static final String peerPressure = "peerPressure";
        public static final String program = "program";
        public static final String by = "by";
        public static final String times = "times";
        public static final String as = "as";
        public static final String option = "option";

        private Symbols() {
        }
    }

    public static interface Admin<S, E>
    extends Traversal.Admin<S, E>,
    GraphTraversal<S, E> {
        @Override
        default public <E2> Admin<S, E2> addStep(Step<?, E2> step) {
            return (Admin)Traversal.Admin.super.addStep(step);
        }

        @Override
        default public GraphTraversal<S, E> iterate() {
            return GraphTraversal.super.iterate();
        }

        @Override
        public Admin<S, E> clone();
    }
}

