/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class BytecodeHelper {
    private BytecodeHelper() {
    }

    public static Bytecode filterInstructions(Bytecode bytecode, Predicate<Bytecode.Instruction> predicate) {
        Bytecode clone = new Bytecode();
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addSource(instruction.getOperator(), instruction.getArguments());
        }
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addStep(instruction.getOperator(), instruction.getArguments());
        }
        return clone;
    }

    public static Optional<String> getLambdaLanguage(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            for (Object object : instruction.getArguments()) {
                Optional<String> temp;
                if (object instanceof Lambda) {
                    return Optional.of(((Lambda)object).getLambdaLanguage());
                }
                if (!(object instanceof Bytecode) || !(temp = BytecodeHelper.getLambdaLanguage((Bytecode)object)).isPresent()) continue;
                return temp;
            }
        }
        return Optional.empty();
    }
}

