/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class PropertyMapStep<E>
extends MapStep<Element, Map<String, E>>
implements TraversalParent {
    protected final String[] propertyKeys;
    protected final PropertyType returnType;
    protected final boolean includeTokens;
    protected Traversal.Admin<Element, ? extends Property> propertyTraversal;

    public PropertyMapStep(Traversal.Admin traversal, boolean includeTokens, PropertyType propertyType, String ... propertyKeys) {
        super(traversal);
        this.includeTokens = includeTokens;
        this.propertyKeys = propertyKeys;
        this.returnType = propertyType;
        this.propertyTraversal = null;
    }

    @Override
    protected Map<String, E> map(Traverser.Admin<Element> traverser) {
        Iterator properties;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Element element = (Element)traverser.get();
        boolean isVertex = traverser.get() instanceof Vertex;
        Iterator iterator = properties = null == this.propertyTraversal ? element.properties(this.propertyKeys) : TraversalUtil.applyAll(traverser, this.propertyTraversal);
        while (properties.hasNext()) {
            Property property = properties.next();
            if (isVertex) {
                ArrayList values = (ArrayList)map.get(property.key());
                if (null == values) {
                    values = new ArrayList();
                    map.put(property.key(), values);
                }
                values.add(this.returnType == PropertyType.VALUE ? property.value() : property);
                continue;
            }
            map.put(property.key(), this.returnType == PropertyType.VALUE ? property.value() : property);
        }
        if (this.returnType == PropertyType.VALUE && this.includeTokens) {
            if (element instanceof VertexProperty) {
                map.put(T.id, element.id());
                map.put(T.key, ((VertexProperty)element).key());
                map.put(T.value, ((VertexProperty)element).value());
            } else {
                map.put(T.id, element.id());
                map.put(T.label, element.label());
            }
        }
        return map;
    }

    public List<Traversal.Admin<Element, ? extends Property>> getLocalChildren() {
        return null == this.propertyTraversal ? Collections.emptyList() : Collections.singletonList(this.propertyTraversal);
    }

    public void setPropertyTraversal(Traversal.Admin<Element, ? extends Property> propertyTraversal) {
        this.propertyTraversal = this.integrateChild(propertyTraversal);
    }

    public PropertyType getReturnType() {
        return this.returnType;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    public boolean isIncludeTokens() {
        return this.includeTokens;
    }

    @Override
    public String toString() {
        return null != this.propertyTraversal ? StringFactory.stepString(this, this.propertyTraversal, this.returnType.name().toLowerCase()) : StringFactory.stepString(this, Arrays.asList(this.propertyKeys), this.returnType.name().toLowerCase());
    }

    @Override
    public PropertyMapStep<E> clone() {
        PropertyMapStep clone = (PropertyMapStep)super.clone();
        if (null != this.propertyTraversal) {
            clone.propertyTraversal = this.propertyTraversal.clone();
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.returnType.hashCode() ^ Boolean.hashCode(this.includeTokens);
        if (null == this.propertyTraversal) {
            for (String propertyKey : this.propertyKeys) {
                result ^= propertyKey.hashCode();
            }
        } else {
            result ^= this.propertyTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (null != this.propertyTraversal) {
            this.integrateChild(this.propertyTraversal);
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }
}

